<?php $sitesetting = App\Models\Sitesetting::first();  ?>
<?php $__env->startSection('meta'); ?>
  <meta name="description" content="<?php echo e($sitesetting->meta_desc); ?>" />
  <meta name="keywords" content="<?php echo e($sitesetting->meta_keyword); ?>" />
  <meta name="author" content="<?php echo e($sitesetting->comp_name); ?>" />
  <meta name="robots" content="index, follow" />
  <link rel="canonical" href="<?php echo e(url('/')); ?>" />
  <meta property="og:title" content="<?php echo e($sitesetting->comp_name); ?>" />
  <meta property="og:description" content="<?php echo e($sitesetting->meta_desc); ?>" />

  <meta property="og:url" content="<?php echo e(url('/')); ?>" />
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="630">
  <meta property="og:type" content="website" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="<?php echo e($sitesetting->comp_name); ?>" />
  <meta name="twitter:description" content="<?php echo e($sitesetting->meta_desc); ?>" />

  <meta name="twitter:image:width" content="1200">
  <meta name="twitter:image:height" content="675">
<?php $__env->stopSection(); ?>
<script type="application/ld+json">
  {
    "@context": "https://schema.org",
    "@type": "Organization",
    "name": "<?php echo e($sitesetting->comp_name ?? 'Pandit Chirag Guruji'); ?>",
    "url": "<?php echo e(url('/')); ?>",
    "logo": "<?php echo e(asset($sitesetting->image ?? '')); ?>",
    "description": "Guiding lives through the ancient wisdom of the stars, offering trusted astrological insights, remedies, and predictions to help you make informed decisions and embrace your destiny with confidence.",
    "contactPoint": [
      {
        "@type": "ContactPoint",
        "telephone": <?php echo e($sitesetting->comp_phone); ?>,
        "areaServed": "IN",
        "availableLanguage": ["Hindi", "English","Gujarati"]
      }
    ],
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "<?php echo e(strip_tags($sitesetting->comp_address ?? '')); ?>",
      "addressLocality": "Rajkot",
      "addressRegion": "Gujarat",
      "postalCode": "360021",
      "addressCountry": "IN"
    },
    "breadcrumb": {
      "@type": "BreadcrumbList",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "<?php echo e(url('/')); ?>"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Services",
          "item": "<?php echo e(url('/')); ?>/services"
        }
      ]
    }
  }
</script>



<?php $__env->startSection('pagetitle'); ?>
  <title><?php echo e($sitesetting->comp_name); ?> | Services</title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<!-- partial:partia/__subheader.html -->
  <div class="sigma_subheader dark-overlay dark-overlay-2" style="background-image: url(<?php echo e(asset('assets/user/images/subheader.jpg')); ?>)">

    <div class="container">
      <div class="sigma_subheader-inner">
        <div class="sigma_subheader-text">
          <h1>Services</h1>
        </div>
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a class="btn-link" href="<?php echo e(url('/')); ?>">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Services</li>
          </ol>
        </nav>
      </div>
    </div>

  </div>
<!-- partial -->

  <div class="section section-padding pattern-squares dark-bg-2" style="z-index: 0;">
    <div class="container">

      <div class="section-title text-start">
        <h4 class="subtitle text-white">service</h4>
        <h4 class="title text-white">Unlock the Secrets of Your Future</h4>
      </div>

      <div class="row">

        <?php if(!empty($services) && $services->isNotEmpty()): ?>
          <?php
              $bgClasses = ['primary-bg', 'secondary-bg', 'bg-white']; 
              $i = 0;
          ?>
          <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php
                  $desc = Str::limit(strip_tags($service->description), 100);
                  $bgClass = $bgClasses[$i % count($bgClasses)];
                  $i++;
              ?>
              <div class="col-lg-4 col-md-6">
                  <a href="javascript:void(0)" class="sigma_service style-1 <?php echo e($bgClass); ?>">
                      <div class="sigma_service-thumb">
                          <img src="<?php echo e($service->image ? asset($service->image) : asset('public/assets/admin/images/not-available.jpg')); ?>" 
                              alt="Icon" 
                              style="width:100px; height:100px;">
                      </div>
                      <div class="sigma_service-body">
                          <h5 class="<?php echo e($bgClass == 'bg-white' ? '' : 'text-white'); ?>"><?php echo e($service->name ?? ''); ?></h5>
                          <p class="<?php echo e($bgClass == 'bg-white' ? '' : 'text-white'); ?>"><?php echo $desc; ?></p>
                      </div>
                  </a>
              </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
          <div class="col-12 text-center py-5">
              <h3 style="color:#888; font-weight:600;">Services Coming Soon!</h3>
              <p style="color:#aaa; font-size:16px;">Stay tuned, we’re preparing something amazing for you.</p>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layout.subapp', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/panditchiragguru/public_html/development.panditchiragguruji.com/resources/views/user/services.blade.php ENDPATH**/ ?>