<?php 
$sitesetting = \App\Models\Sitesetting::first();

function preserve_styles_limit($html, $maxLength = 300, $end = '') {
    $printedLength = 0;
    $position = 0;
    $tags = [];
    $result = '';

    preg_match_all('/(<[^>]+>|[^<]+)/', $html, $matches);

    foreach ($matches[0] as $part) {
        if ($part[0] === '<') {
            if ($part[1] === '/') {
                array_pop($tags);
                $result .= $part;
            } else {
                preg_match('/<([a-z0-9]+)[^>]*>/i', $part, $tagMatch);
                array_push($tags, $tagMatch[1]);
                $result .= $part;
            }
        } else {
            if ($printedLength + strlen($part) > $maxLength) {
                $result .= substr($part, 0, $maxLength - $printedLength) . $end;
                break;
            } else {
                $result .= $part;
                $printedLength += strlen($part);
            }
        }
    }

    while (!empty($tags)) {
        $result .= '</' . array_pop($tags) . '>';
    }

    return $result;
}
?>
<footer class="sigma_footer footer-2">

    <!-- Middle Footer -->
    <div class="sigma_footer-middle">
      <div class="container">
        <div class="row">
          <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 footer-widget">
            <h5 class="widget-title"><?php echo preserve_styles_limit($sitesetting->about_title ?? '', 50); ?></h5>
            <p class="mb-4"><?php echo preserve_styles_limit($sitesetting->abt_detail ?? '', 167); ?></p>
            <div class="d-flex align-items-center justify-content-md-start justify-content-center">
              <i class="far fa-phone custom-primary me-3"></i>
              <?php if(!empty($sitesetting->comp_phone)): ?>
                  <span>
                      <a href="tel:+91<?php echo e($sitesetting->comp_phone); ?>" style="color: inherit; text-decoration: none;">
                          <i class="fas fa-phone-alt"></i>+91 <?php echo e($sitesetting->comp_phone); ?>

                      </a>
                  </span>
              <?php endif; ?>
            </div>  
            <div class="d-flex align-items-center justify-content-md-start justify-content-center mt-2">
              <i class="far fa-envelope custom-primary me-3"></i>
              <?php if(!empty($sitesetting->comp_email)): ?>
                  <span>
                      <a href="mailto:<?php echo e($sitesetting->comp_email); ?>" style="color: inherit; text-decoration: none;">
                          <?php echo e($sitesetting->comp_email); ?>

                      </a>
                  </span>
              <?php endif; ?>
            </div>          
            <div class="d-flex align-items-center justify-content-md-start justify-content-center mt-2">
              <i class="far fa-map-marker custom-primary me-3"></i>
              <?php if(!empty($sitesetting->comp_address)): ?>
                  <span class="address-text"><?php echo $sitesetting->comp_address; ?></span>
              <?php endif; ?>
            </div>          
          </div>
          <div class="col-xl-2 col-lg-2 col-md-4 col-sm-12 footer-widget">
            <h5 class="widget-title">Information</h5>
            <ul>
              <li>
                <a href="<?php echo e(url('/')); ?>">Home</a> 
              </li>
              <li>
                <a href="<?php echo e(url('about')); ?>">About Us</a> 
              </li>
              <li>
                <a href="<?php echo e(url('services')); ?>">Services</a> 
              </li>
              <li>
                <a href="<?php echo e(url('gallery')); ?>">Gallery</a> 
              </li>
              <li>
                <a href="<?php echo e(url('contact')); ?>">Contact Us</a>
              </li>
            </ul>
          </div>
          <div class="col-xl-6 col-lg-6 col-md-3 col-sm-12 d-none d-lg-block footer-widget widget-map">
            <h5 class="widget-title">Our Location</h5>
        
            <?php if(!empty($sitesetting->comp_address)): ?>
                <div style="width: 100%; height: 250px; border-radius: 8px; overflow: hidden;">
                    <iframe
                        width="100%"
                        height="100%"
                        frameborder="0"
                        style="border:0;"
                        src="https://www.google.com/maps?q=<?php echo e(urlencode($sitesetting->comp_address)); ?>&output=embed"
                        allowfullscreen>
                    </iframe>
                </div>
                <p style="margin-top: 10px;">
                    <i class="fas fa-map-marker-alt"></i> <?php echo $sitesetting->comp_address; ?>

                </p>
            <?php else: ?>
                <p>No location available.</p>
            <?php endif; ?>
          </div>        
        </div>
      </div>
    </div>

    <!-- Footer Bottom -->
    <div class="sigma_footer-bottom">
      <div class="container-fluid">
        <div class="sigma_footer-copyright">
          <p> Copyright ©Pandit Chirag Guruji - <a href="#" class="custom-primary">2025</a> </p>
        </div>
        <div class="sigma_footer-logo">
          <a href="<?php echo e(url('/')); ?>">
            <img class="res_img_height" src="<?php echo e($sitesetting->image 
                ? asset($sitesetting->image) 
                : asset('assets/user/images/logo.jpg')); ?>" 
                alt="logo">
        </a>
        </div>
        <ul class="sigma_sm square">
          <?php if(!empty($sitesetting->comp_fb)): ?>
              <li>
                  <a href="<?php echo e($sitesetting->comp_fb); ?>" target="_blank" rel="noopener">
                      <i class="fab fa-facebook-f"></i>
                  </a>
              </li>
          <?php endif; ?>

          <?php if(!empty($sitesetting->insta_link)): ?>
              <li>
                  <a href="<?php echo e($sitesetting->insta_link); ?>" target="_blank" rel="noopener">
                      <i class="fab fa-instagram"></i>
                  </a>
              </li>
          <?php endif; ?>

          <?php if(!empty($sitesetting->comp_tweeter)): ?>
              <li>
                  <a href="<?php echo e($sitesetting->comp_tweeter); ?>" target="_blank" rel="noopener">
                      <i class="fab fa-twitter"></i>
                  </a>
              </li>
          <?php endif; ?>

          <?php if(!empty($sitesetting->youtube_link)): ?>
              <li>
                  <a href="<?php echo e($sitesetting->youtube_link); ?>" target="_blank" rel="noopener">
                      <i class="fab fa-youtube"></i>
                  </a>
              </li>
          <?php endif; ?>
        </ul>
      </div>
    </div>

  </footer><?php /**PATH /home/panditchiragguru/public_html/development.panditchiragguruji.com/resources/views/user/layout/footer.blade.php ENDPATH**/ ?>