<?php $__env->startSection('content'); ?>
<div class="main-content app-content">
    <div class="main-container container-fluid">

        <!-- Breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <h4 class="content-title mb-0 my-auto">Forecast</h4>
                <span class="text-muted mt-1 tx-13 ms-2 mb-0">
                    / <?php echo e($record ? 'Edit' : 'New'); ?> Forecast
                </span>
            </div>
        </div>

        <!-- Card -->
        <div class="row row-sm">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"><?php echo e($record ? 'Edit' : 'New'); ?> Forecast</h4>
                    </div>

                    <form action="<?php echo e($record ? url('admin/forecast/' . $record->id . '/update') : url('admin/forecast/store')); ?>"
                        method="POST"
                        enctype="multipart/form-data"
                        class="ajax_submit">

                        <?php echo csrf_field(); ?>

                        <div class="card-body">
                            <?php echo $__env->make('admin.forecast.form', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </div>

                        <div class="card-footer">
                            <a href="<?php echo e(url('admin/forecast')); ?>" class="btn btn-secondary">Back</a>
                            <button type="submit" class="btn btn-primary float-end">
                                <?php echo e($record ? 'Update' : 'Save'); ?> Forecast
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
jQuery(function($) {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $('.ajax_submit').on('submit', function(e) {
        e.preventDefault();
        let form = $(this);
        let btn = form.find('button[type="submit"]');
        let btnText = btn.text();

        btn.prop('disabled', true).text('Saving...');

        $.ajax({
            url: form.attr('action'),
            type: 'POST',
            data: new FormData(this),
            processData: false,
            contentType: false,
            success: function(res) {
                if (res.success) {
                    alert(res.message);
                    window.location.href = res.redirect;
                } else {
                    alert(res.message || 'Failed!');
                }
            },
            error: function(xhr) {
                let errors = xhr.responseJSON?.errors;
                if (errors) {
                    alert(Object.values(errors).flat().join('\n'));
                } else {
                    alert('Server error. Check console.');
                    console.log(xhr);
                }
            },
            complete: function() {
                btn.prop('disabled', false).text(btnText);
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/panditchiragguru/public_html/resources/views/admin/forecast/create.blade.php ENDPATH**/ ?>