@extends('user.layout.subapp')
@php $sitesetting = App\Models\Sitesetting::first();  @endphp
@section('meta')
  <meta name="description" content="{{$sitesetting->meta_desc}}" />
  <meta name="keywords" content="{{$sitesetting->meta_keyword}}" />
  <meta name="author" content="{{$sitesetting->comp_name}}" />
  <meta name="robots" content="index, follow" />
  <link rel="canonical" href="{{url('/')}}" />
  <meta property="og:title" content="{{$sitesetting->comp_name}}" />
  <meta property="og:description" content="{{$sitesetting->meta_desc}}" />

  <meta property="og:url" content="{{ url('/') }}" />
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="630">
  <meta property="og:type" content="website" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="{{$sitesetting->comp_name}}" />
  <meta name="twitter:description" content="{{$sitesetting->meta_desc}}" />

  <meta name="twitter:image:width" content="1200">
  <meta name="twitter:image:height" content="675">
@endsection
<script type="application/ld+json">
  {
    "@context": "https://schema.org",
    "@type": "Organization",
    "name": "{{ $sitesetting->comp_name ?? 'Pandit Chirag Guruji' }}",
    "url": "{{ url('/') }}",
    "logo": "{{ asset($sitesetting->image ?? '') }}",
    "description": "Guiding lives through the ancient wisdom of the stars, offering trusted astrological insights, remedies, and predictions to help you make informed decisions and embrace your destiny with confidence.",
    "contactPoint": [
      {
        "@type": "ContactPoint",
        "telephone": {{ $sitesetting->comp_phone }},
        "areaServed": "IN",
        "availableLanguage": ["Hindi", "English","Gujarati"]
      }
    ],
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "{{ strip_tags($sitesetting->comp_address ?? '') }}",
      "addressLocality": "Rajkot",
      "addressRegion": "Gujarat",
      "postalCode": "360021",
      "addressCountry": "IN"
    },
    "breadcrumb": {
      "@type": "BreadcrumbList",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "{{ url('/') }}"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Services",
          "item": "{{ url('/') }}/services"
        }
      ]
    }
  }
</script>



@section('pagetitle')
  <title>{{$sitesetting->comp_name}} | Services</title>
@endsection
@section('content')

<!-- partial:partia/__subheader.html -->
  <div class="sigma_subheader dark-overlay dark-overlay-2" style="background-image: url({{asset('assets/user/images/subheader.jpg')}})">

    <div class="container">
      <div class="sigma_subheader-inner">
        <div class="sigma_subheader-text">
          <h1>Services</h1>
        </div>
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a class="btn-link" href="{{url('/')}}">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Services</li>
          </ol>
        </nav>
      </div>
    </div>

  </div>
<!-- partial -->

  <div class="section section-padding pattern-squares dark-bg-2" style="z-index: 0;">
    <div class="container">

      <div class="section-title text-start">
        <h4 class="subtitle text-white">service</h4>
        <h4 class="title text-white">Unlock the Secrets of Your Future</h4>
      </div>

      <div class="row">

        @if(!empty($services) && $services->isNotEmpty())
          @php
              $bgClasses = ['primary-bg', 'secondary-bg', 'bg-white']; 
              $i = 0;
          @endphp
          @foreach($services as $service)
              @php
                  $desc = Str::limit(strip_tags($service->description), 100);
                  $bgClass = $bgClasses[$i % count($bgClasses)];
                  $i++;
              @endphp
              <div class="col-lg-4 col-md-6">
                  <a href="javascript:void(0)" class="sigma_service style-1 {{ $bgClass }}">
                      <div class="sigma_service-thumb">
                          <img src="{{ $service->image ? asset($service->image) : asset('public/assets/admin/images/not-available.jpg') }}" 
                              alt="Icon" 
                              style="width:100px; height:100px;">
                      </div>
                      <div class="sigma_service-body">
                          <h5 class="{{ $bgClass == 'bg-white' ? '' : 'text-white' }}">{{ $service->name ?? '' }}</h5>
                          <p class="{{ $bgClass == 'bg-white' ? '' : 'text-white' }}">{!! $desc !!}</p>
                      </div>
                  </a>
              </div>
          @endforeach
        @else
          <div class="col-12 text-center py-5">
              <h3 style="color:#888; font-weight:600;">Services Coming Soon!</h3>
              <p style="color:#aaa; font-size:16px;">Stay tuned, we’re preparing something amazing for you.</p>
          </div>
        @endif
      </div>
    </div>
  </div>
@endsection
