@extends('user.layout.app')
@php $sitesetting = App\Models\Sitesetting::first(); @endphp
@section('meta')
<meta name="description" content="{{$sitesetting->meta_desc}}" />
<meta name="keywords" content="{{$sitesetting->meta_keyword}}" />
<meta name="author" content="{{$sitesetting->comp_name}}" />
<meta name="robots" content="index, follow" />
<link rel="canonical" href="{{url('/')}}" />
<meta property="og:title" content="{{$sitesetting->comp_name}}" />
<meta property="og:description" content="{{$sitesetting->meta_desc}}" />

<meta property="og:url" content="{{ url('/') }}" />
<meta property="og:image:width" content="1200">
<meta property="og:image:height" content="630">
<meta property="og:type" content="website" />
<meta name="twitter:card" content="summary_large_image" />
<meta name="twitter:title" content="{{$sitesetting->comp_name}}" />
<meta name="twitter:description" content="{{$sitesetting->meta_desc}}" />

<meta name="twitter:image:width" content="1200">
<meta name="twitter:image:height" content="675">
@endsection
<script type="application/ld+json">
  {
    "@context": "https://schema.org",
    "@type": "Organization",
    "name": "{{ $sitesetting->comp_name ?? 'Pandit Chirag Guruji' }}",
    "url": "{{ url('/') }}",
    "logo": "{{ asset($sitesetting->image ?? '') }}",
    "description": "Guiding lives through the ancient wisdom of the stars, offering trusted astrological insights, remedies, and predictions to help you make informed decisions and embrace your destiny with confidence.",
    "contactPoint": [{
      "@type": "ContactPoint",
      "telephone": {
        {
          $sitesetting - > comp_phone
        }
      },
      "areaServed": "IN",
      "availableLanguage": ["Hindi", "English", "Gujarati"]
    }],
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "{{ strip_tags($sitesetting->comp_address ?? '') }}",
      "addressLocality": "Rajkot",
      "addressRegion": "Gujarat",
      "postalCode": "360021",
      "addressCountry": "IN"
    },
    "breadcrumb": {
      "@type": "BreadcrumbList",
      "itemListElement": [{
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "{{ url('/') }}"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Services",
          "item": "{{ url('/') }}/services"
        }
      ]
    }
  }
</script>



@section('pagetitle')
<title>{{$sitesetting->comp_name}}</title>
@endsection
@section('content')
<div class="sigma_banner banner-3">
  <div class="sigma_banner-slider">
    <!-- Banner Item Start -->
    @if(!empty($sliders) && $sliders->isNotEmpty())
    @foreach($sliders as $slider)
    <div class="light-bg sigma_banner-slider-inner bg-cover bg-center bg-norepeat"
      style="background-image: url('{{ asset($slider->image) }}'); background-size: 100% 100%;">
      <div class="sigma_banner-text">
        <div class="container">
          <div class="row align-items-center" style="min-height: 331px;">
          </div>
        </div>
      </div>
    </div>
    @endforeach
    @else
    <div class="light-bg sigma_banner-slider-inner bg-cover bg-center bg-norepeat" style="background-image: url('{{asset('assets/user/images/banner/3.jpg')}}'); ">
      <div class="sigma_banner-text">
        <div class="container">
          <div class="row align-items-center" style="min-height: 331px;">
          </div>
        </div>
      </div>
    </div>
    @endif
    <!-- Banner Item End -->
  </div>
</div>
<!-- Banner End -->

@php
function html_limit_with_style($html, $maxLength = 300, $end = '...') {
$printedLength = 0;
$position = 0;
$tags = [];
$result = '';

preg_match_all('/(<[^>]+>|[^<]+) /', $html, $matches);

    foreach ($matches[0] as $part) {
    if ($part[0]==='<' ) {
    if ($part[1]==='/' ) {
    array_pop($tags);
    $result .=$part;
    } else {
    preg_match('/<([a-z0-9]+)[^>]*>/i', $part, $tagMatch);
    array_push($tags, $tagMatch[1]);
    $result .= $part;
    }
    } else {
    if ($printedLength + strlen($part) > $maxLength) {
    $result .= substr($part, 0, $maxLength - $printedLength) . $end;
    break;
    } else {
    $result .= $part;
    $printedLength += strlen($part);
    }
    }
    }

    while (!empty($tags)) {
    $result .= '</' . array_pop($tags) . '>' ;
      }

      return $result;
      }
      @endphp
      <!-- About Start -->
    <section class="section">
      <div class="container">

        <div class="row align-items-center">
          <div class="col-lg-6 mb-lg-30">
            <div class="img-group">
              <div class="img-group-inner">
                <img class="img-fixed-1" src="{{ $education->image1 ? asset($education->image1) : asset('assets/user/images/about-group1/1.jpg') }}" alt="about">
                <span></span>
                <span></span>
              </div>
              <img class="img-fixed-2" src="{{ $education->image1 ? asset($education->image2) : asset('assets/user/images/about-group1/2.jpg') }}" alt="about">
              <img class="img-fixed-3" src="{{ $education->image1 ? asset($education->image3) : asset('assets/user/images/about-group1/3.jpg') }}" alt="about">
            </div>
          </div>
          <div class="col-lg-6">
            <div class="me-lg-30">
              <div class="section-title mb-0 text-start">
                <p class="home-about-sec">{{ $education->name ?? '' }}</p>
                <h4 class="title">{{ $education->title ?? '' }}</h4>
              </div>
              <p class="bg-transparent">
                {!! html_limit_with_style($education->description ?? '', 337) !!}
              </p>
              <a href="{{ route('about')}}" class="sigma_btn-custom light">Learn More <i class="far fa-arrow-right"></i> </a>
            </div>
          </div>
        </div>

      </div>
    </section>
    <!-- About End -->

    <!-- holi Start -->
    <div class="section section-padding pattern-squares dark-bg-2">
      <div class="container">

        <div class="section-title text-start">
          <h4 class="subtitle text-white">View Our Services</h4>
          <h4 class="title text-white">Unlock the Secrets of Your Future</h4>
        </div>

        <div class="row">

          @if(!empty($services) && $services->isNotEmpty())
          @php
          $bgClasses = ['primary-bg', 'secondary-bg', 'bg-white'];
          $i = 0;
          @endphp
          @foreach($services as $service)
          @php
          $desc = Str::limit(strip_tags($service->description), 100);
          $bgClass = $bgClasses[$i % count($bgClasses)];
          $i++;
          @endphp
          <div class="col-lg-4 col-md-6">
            <a href="{{url('about')}}" class="sigma_service style-1 {{ $bgClass }}">
              <div class="sigma_service-thumb">
                <img src="{{ $service->image ? asset($service->image) : asset('public/assets/admin/images/not-available.jpg') }}"
                  alt="Icon"
                  style="width:100px; height:100px;">
              </div>
              <div class="sigma_service-body">
                <h5 class="{{ $bgClass == 'bg-white' ? '' : 'text-white' }}">{{ $service->name ?? '' }}</h5>
                <p class="{{ $bgClass == 'bg-white' ? '' : 'text-white' }}">{!! $desc !!}</p>
              </div>
            </a>
          </div>
          @endforeach
          @else
          <div class="col-12 text-center py-5">
            <h3 style="color:#888; font-weight:600;">Services Coming Soon!</h3>
            <p style="color:#aaa; font-size:16px;">Stay tuned, we’re preparing something amazing for you.</p>
          </div>
          @endif
        </div>

      </div>
    </div>
    <!-- holi End -->

    <!-- Testimonials Start -->
    <section class="section">

      <div class="container testimonial-section bg-contain bg-norepeat bg-center" style="background-image: url({{asset('assets/user/images/textures/map-2.png')}})">

        <div class="section-title text-center">
          <p class="subtitle">Testimonials</p>
          <h4 class="title">What Our Clients Say</h4>
        </div>

        <div class="sigma_testimonial style-2">
          <div class="sigma_testimonial-slider">

            @if(!empty($testimonials) && $testimonials->isNotEmpty())
            @foreach($testimonials as $testimonial)
            <div class="sigma_testimonial-inner">
              <div class="sigma_testimonial-thumb">
                <img class="testimonial_img" src="{{ $testimonial->image ? asset($testimonial->image) : asset('public/assets/admin/images/not-available.jpg') }}" alt="testimonial">
              </div>
              <div>
                <div class="sigma_testimonial-body fix-space">
                  <div class="sigma_rating-wrapper">
                  </div>
                  <p class="fix-size-p">{!! $testimonial->description ?? '' !!}</p>
                  {{-- <p class="fix-size-p">{!! html_limit_with_style($testimonial->description ?? '', 150) !!}</p> --}}
                </div>
                <div class="sigma_testimonial-footer">
                  <div class="sigma_testimonial-author">
                    <cite>{{ $testimonial->name ?? '' }}</cite>
                    <span>{{ $testimonial->designation ?? '' }}</span>
                  </div>
                </div>
              </div>
            </div>
            @endforeach
            @else
            <div style="text-align:center; padding:40px; background:#f9f9f9; border-radius:8px; font-size:16px; color:#555;">
              <em>We value your feedback — testimonials will be shared here soon.</em>
            </div>
            @endif
          </div>
        </div>
        @if(!empty($testimonials) && $testimonials->count() >= 3)
        <div class="text-center mt-4">
          <div class="sigma_arrows style-2">
            <i class="far fa-chevron-left slick-arrow slider-prev"></i>
            <i class="far fa-chevron-right slick-arrow slider-next"></i>
          </div>
        </div>
        @endif
      </div>
    </section>
    <!-- Testimonials End -->

    {{-- resources/views/user/forecasts.blade.php --}}
    <div class="section pt-0">
        <div class="container">
            <div class="section-title text-center">
                <p class="subtitle">Horoscope</p>
                <h4 class="title">Weekly Forecasts</h4>
            </div>

            <div class="row g-3">
                @forelse($forecasts as $forecast)
                    <div class="col-lg-2 col-sm-4 col-6">
                        <div class="as_sign_box text-center">
                            <a href="{{ url('forecast-details/' . $forecast->slug) }}" class="text-decoration-none">
                                <span class="as_sign">
                                    <img 
                                        src="{{ $forecast->image ? asset('assets/admin/' . $forecast->image) : asset('assets/images/zodiac-placeholder.svg') }}" 
                                        alt="{{ strip_tags($forecast->title) }}"
                                        class="img-fluid d-inline-block"
                                    >
                                </span>

                                <div>
                                    <h5>{!! Str::limit(strip_tags($forecast->title), 30) !!}</h5>
                                    <p class="text-muted mb-0" style="font-size:12px;">{{ $forecast->start_date }} - {{ $forecast->end_date }}</p>
                                </div>
                            </a>
                        </div>
                    </div>
                @empty
                    <div class="col-12 text-center py-5">
                        <p class="text-muted">No forecasts available for this week.</p>
                    </div>
                @endforelse
            </div>
        </div>
    </div>

    <!-- CTA Start -->
    <div class="section pt-0">
      <div class="container">
        <div class="section-title text-center">
          <p class="subtitle">Media</p>
          <h4 class="title">Daily Update</h4>
        </div>

        <div class="row align-items-center position-relative">
          @if(!empty($media) && $media->isNotEmpty())
          @foreach($media as $key => $mediaItem)
          @php
          // Extract YouTube video ID
          preg_match('/(?:youtu\.be\/|youtube\.com\/(?:watch\?v=|embed\/))([^\?&]+)/', $mediaItem->link, $matches);
          $videoId = $matches[1] ?? null;
          @endphp

          @if($videoId)
          <div class="col-md-4 mb-4">
            <div class="sigma_portfolio-item style-2">

              {{-- Video Thumbnail --}}
              <div class="youtube-thumbnail-wrapper" data-video-id="{{ $videoId }}">
                <img src="https://img.youtube.com/vi/{{ $videoId }}/hqdefault.jpg" alt="Video Thumbnail" class="img-fluid">
                <div class="play_button_thumb">
                  <i class="fa fa-play-circle"></i>
                </div>
              </div>

              {{-- Content --}}
              <div class="sigma_portfolio-item-content">
                <div class="sigma_portfolio-item-content-inner">
                  {!! $mediaItem->description !!}
                </div>
                <a href="{{ $mediaItem->link }}" target="_blank">
                  <i class="far fa-arrow-right"></i>
                </a>
              </div>
            </div>
          </div>

          {{-- Show span only if not last item --}}
          @if($key < count($media) - 1)
            <span class="sigma_cta-sperator d-none d-lg-flex">or</span>
            @endif
            @endif
            @endforeach
            @else
            <div style="text-align:center; padding:40px; background:#f9f9f9; border-radius:8px; font-size:16px; color:#555;">
              <em>We value your interest — videos will be shared here soon.</em>
            </div>
            @endif
        </div>

      </div>
    </div>
    <!-- CTA End -->

    <!-- Blog Start -->
    <div class="section section-padding pt-0">
      <div class="container">

        <div class="section-title text-center">
          <p class="subtitle">Blog</p>
          <h4 class="title">News Feed</h4>
        </div>

        <div class="row">

          @php
          use Illuminate\Support\Str;
          @endphp

          @if(!empty($blogs) && $blogs->isNotEmpty())
          @foreach($blogs as $blog)
          <!-- Article Start -->
          <div class="col-lg-4 col-md-6">
            <article class="sigma_post">
              <div class="sigma_post-thumb">
                <a href="javascript:void(0)">
                  <img class="blog_img" src="{{ $blog->image ? asset($blog->image) : asset('public/assets/admin/images/not-available.jpg') }}" alt="post">
                </a>
              </div>
              <div class="sigma_post-body">
                <div class="sigma_post-meta">
                  <div class="me-3">
                    <a href="javascript:void(0)" class="sigma_post-category">{{ $blog->name}}</a>
                  </div>
                </div>
                <h5>
                  <a href="javascript:void(0)">
                    {{ $blog->short_description}}
                  </a>
                </h5>
              </div>
            </article>
          </div>
          <!-- Article End -->
          @endforeach
          @else
          <div style="text-align:center; padding:40px; background:#f9f9f9; border-radius:8px; font-size:16px; color:#555;">
            <em>We value your interest — Blogs will be shared here soon.</em>
          </div>
          @endif

        </div>
      </div>
      <div class="spacer spacer-bottom spacer-lg light-bg pattern-triangles"></div>

    </div>
    @endsection