@extends('user.layout.subapp')
@php $sitesetting = App\Models\Sitesetting::first();  @endphp
@section('meta')
  <meta name="description" content="{{$sitesetting->meta_desc}}" />
  <meta name="keywords" content="{{$sitesetting->meta_keyword}}" />
  <meta name="author" content="{{$sitesetting->comp_name}}" />
  <meta name="robots" content="index, follow" />
  <link rel="canonical" href="{{url('/')}}" />
  <meta property="og:title" content="{{$sitesetting->comp_name}}" />
  <meta property="og:description" content="{{$sitesetting->meta_desc}}" />

  <meta property="og:url" content="{{ url('/') }}" />
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="630">
  <meta property="og:type" content="website" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="{{$sitesetting->comp_name}}" />
  <meta name="twitter:description" content="{{$sitesetting->meta_desc}}" />

  <meta name="twitter:image:width" content="1200">
  <meta name="twitter:image:height" content="675">
@endsection
<script type="application/ld+json">
  {
    "@context": "https://schema.org",
    "@type": "Organization",
    "name": "{{ $sitesetting->comp_name ?? 'Pandit Chirag Guruji' }}",
    "url": "{{ url('/') }}",
    "logo": "{{ asset($sitesetting->image ?? '') }}",
    "description": "Guiding lives through the ancient wisdom of the stars, offering trusted astrological insights, remedies, and predictions to help you make informed decisions and embrace your destiny with confidence.",
    "contactPoint": [
      {
        "@type": "ContactPoint",
        "telephone": {{ $sitesetting->comp_phone }},
        "areaServed": "IN",
        "availableLanguage": ["Hindi", "English","Gujarati"]
      }
    ],
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "{{ strip_tags($sitesetting->comp_address ?? '') }}",
      "addressLocality": "Rajkot",
      "addressRegion": "Gujarat",
      "postalCode": "360021",
      "addressCountry": "IN"
    },
    "breadcrumb": {
      "@type": "BreadcrumbList",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "{{ url('/') }}"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Services",
          "item": "{{ url('/') }}/services"
        }
      ]
    }
  }
</script>

<style>
.manual-style p {
    margin: 0 0 20px;
    color: #ec6f31;
    font-weight: 700;
    font-size: 28px;
    line-height: 1.4;
}

</style>


@section('pagetitle')
  <title>{{$sitesetting->comp_name}} | Forecast Details</title>
@endsection
@section('content')

<div class="sigma_subheader dark-overlay dark-overlay-2" style="background-image: url({{asset('assets/user/images/subheader.jpg')}})">

    <div class="container">
      <div class="sigma_subheader-inner">
        <div class="sigma_subheader-text">
          <h1>Forecast Details</h1>
        </div>
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a class="btn-link" href="{{url('/')}}">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Forecast Details</li>
          </ol>
        </nav>
      </div>
    </div>

  </div>

  <section class="section">
    <div class="container">
        <div class="text-center">
            <h4 class="manual-style">{!! $forecast->title !!}</h4>
        </div>
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="as_about_detail">
                    <h1 class="as_heading">Description</h1>
                    <div class="as_paragraph_wrapper">
                        {!! $forecast->description !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

{{-- <section class="section">
    <div class="container">
        <div class="text-center">
            <h4>Aries- मेष</h4>
        </div>
        <div class="row">
            <div class="col-lg-12 col-md-12">
                <div class="as_about_detail">
                    <h1 class="as_heading">Description</h1>
                    <div class="as_paragraph_wrapper">
                        <p class="as_margin0 as_font14 as_padderBottom10"></p><p>मेष चंद्र राशि का साप्ताहिक राशिफल (3 नवम्बर से 9 नवम्बर) – Astrologer Chirag Ada Guruji</p>

                        <p>आपकी चंद्र राशि के बारहवें भाव में शनि देव विराजमान होंगे और ऐसे में, इस राशि के उम्रदराज़ जातकों को इस पूरे सप्ताह अपनी सेहत का विशेष ध्यान रखने की ज़रूरत है। हमारे Astrologer Chirag Ada Guruji के अनुसार, इसके लिए सुबह-शाम पार्क में जाकर करीब 30 मिनट तक चलना लाभकारी रहेगा और धूल भरी जगहों से बचना चाहिए।</p>

                        <p>इस सप्ताह कार्यस्थल पर – चाहे वह ऑफिस हो या आपका कारोबार – आपकी कोई लापरवाही आर्थिक नुकसान करा सकती है क्योंकि आपकी चंद्र राशि के पांचवें भाव में केतु देव उपस्थित हैं। Astrologer Chirag Ada Guruji का सुझाव है कि जल्दबाज़ी से बचते हुए हर कार्य को सावधानीपूर्वक करें।</p>

                        <p>नई परियोजनाओं के लिए, अपने माता-पिता को विश्वास में लेना इस समय बेहद जरूरी है। Astrologer Chirag Ada Guruji कहते हैं कि शुरुआत में ही हर योजना के बारे में अपने माता-पिता को बताएं और उनका विचार जानें।</p>

                        <p>यह सप्ताह कार्यक्षेत्र में आपकी दक्षता की परीक्षा लेने वाला सिद्ध होगा। इच्छानुसार परिणाम पाने के लिए, Astrologer Chirag Ada Guruji की सलाह है कि अपनी कोशिशों पर पूरी तरह एकाग्रता बनाए रखें और अपने बड़ों का अनुभव भी इस्तेमाल करें।</p>

                        <p>शिक्षा के क्षेत्र में सफलता पाने के लिए, अपने लक्ष्यों के प्रति प्रतिबद्धता सबसे आवश्यक है। Astrologer Chirag Ada Guruji कहते हैं कि अपनी संगति में सुधार करें और उन लोगों से दूर रहें जो आपको गलत आदतों की ओर ले जा सकते हैं।</p>

                        <p>उपाय: प्रतिदिन "ॐ भौमाय नमः" का 27 बार जाप करें।</p>

                        <p>हमारे Astrologer Chirag Ada Guruji को India best astrologer, Gujarat best Astrologer और Rajkot number 1 astrologer के नाम से जाना जाता है।</p>

                        <p>यदि आपका राशिफल आपको अच्छा लगा हो, तो आप Astrologer Chirag Ada Guruji से संपर्क कर सकते हैं। आपका जीवन बेहतर बनाने के लिए, आप अपनी जन्म पत्रिका हमें दिखा सकते हैं और हमारे Astrologer Chirag Ada Guruji आपके लिए व्यक्तिगत समाधान सुझाएंगे।</p><p></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section> --}}

@endsection