@extends('user.layout.subapp')
@php $sitesetting = App\Models\Sitesetting::first();  @endphp
@section('meta')
  <meta name="description" content="{{$sitesetting->meta_desc}}" />
  <meta name="keywords" content="{{$sitesetting->meta_keyword}}" />
  <meta name="author" content="{{$sitesetting->comp_name}}" />
  <meta name="robots" content="index, follow" />
  <link rel="canonical" href="{{url('/')}}" />
  <meta property="og:title" content="{{$sitesetting->comp_name}}" />
  <meta property="og:description" content="{{$sitesetting->meta_desc}}" />

  <meta property="og:url" content="{{ url('/') }}" />
  <meta property="og:image:width" content="1200">
  <meta property="og:image:height" content="630">
  <meta property="og:type" content="website" />
  <meta name="twitter:card" content="summary_large_image" />
  <meta name="twitter:title" content="{{$sitesetting->comp_name}}" />
  <meta name="twitter:description" content="{{$sitesetting->meta_desc}}" />

  <meta name="twitter:image:width" content="1200">
  <meta name="twitter:image:height" content="675">
@endsection
<script type="application/ld+json">
  {
    "@context": "https://schema.org",
    "@type": "Organization",
    "name": "{{ $sitesetting->comp_name ?? 'Pandit Chirag Guruji' }}",
    "url": "{{ url('/') }}",
    "logo": "{{ asset($sitesetting->image ?? '') }}",
    "description": "Guiding lives through the ancient wisdom of the stars, offering trusted astrological insights, remedies, and predictions to help you make informed decisions and embrace your destiny with confidence.",
    "contactPoint": [
      {
        "@type": "ContactPoint",
        "telephone": {{ $sitesetting->comp_phone }},
        "areaServed": "IN",
        "availableLanguage": ["Hindi", "English","Gujarati"]
      }
    ],
    "address": {
      "@type": "PostalAddress",
      "streetAddress": "{{ strip_tags($sitesetting->comp_address ?? '') }}",
      "addressLocality": "Rajkot",
      "addressRegion": "Gujarat",
      "postalCode": "360021",
      "addressCountry": "IN"
    },
    "breadcrumb": {
      "@type": "BreadcrumbList",
      "itemListElement": [
        {
          "@type": "ListItem",
          "position": 1,
          "name": "Home",
          "item": "{{ url('/') }}"
        },
        {
          "@type": "ListItem",
          "position": 2,
          "name": "Services",
          "item": "{{ url('/') }}/services"
        }
      ]
    }
  }
</script>



@section('pagetitle')
  <title>{{$sitesetting->comp_name}} | Contact Us</title>
@endsection
@section('content')

<!-- partial:partia/__subheader.html -->
  <div class="sigma_subheader dark-overlay dark-overlay-2" style="background-image: url({{asset('assets/user/images/subheader.jpg')}})">

    <div class="container">
      <div class="sigma_subheader-inner">
        <div class="sigma_subheader-text">
          <h1>Contact Us</h1>
        </div>
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a class="btn-link" href="#">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Contact Us</li>
          </ol>
        </nav>
      </div>
    </div>

  </div>
  <!-- partial -->

  <!-- Map Start -->
  <div class="sigma_map">
    <iframe
        width="100%"
        height="100%"
        frameborder="0"
        style="border:0;"
        src="https://www.google.com/maps?q={{ urlencode($sitesetting->comp_address) }}&output=embed"
        allowfullscreen>
    </iframe>
  </div>
  <!-- Map End -->

  {{-- <!-- Contact form Start -->
  <div class="section mt-negative pt-0">
    <div class="container">

      <form class="sigma_box box-lg m-0 mf_form_validate ajax_submit" action="sendmail.php" method="post" enctype="multipart/form-data">
        <div class="row">
          <div class="col-lg-4">
            <div class="form-group">
              <i class="far fa-user"></i>
              <input type="text" placeholder="Full Name" class="form-control dark" name="name">
            </div>
          </div>
          <div class="col-lg-4">
            <div class="form-group">
              <i class="far fa-envelope"></i>
              <input type="email" placeholder="Email Address" class="form-control dark" name="email">
            </div>
          </div>
          <div class="col-lg-4">
            <div class="form-group">
              <i class="far fa-pencil"></i>
              <input type="text" placeholder="Subject" class="form-control dark" name="Subesubject">
            </div>
          </div>
        </div>
        <div class="form-group">
          <textarea name="message" placeholder="Enter Message" cols="45" rows="5" class="form-control dark"></textarea>
        </div>
        <div class="text-center">
          <button type="submit" class="sigma_btn-custom" name="button">Submit Now</button>
          <div class="server_response w-100">
          </div>
        </div>
      </form>

    </div>
  </div>
  <!-- Contact form End --> --}}

  <!-- Icons Start -->
  <div class="section section-padding">
    <div class="container">
      <div class="row equal-height">

        <div class="col-lg-4">
          <div class="sigma_icon-block text-center light icon-block-7">
            <i class="flaticon-email"></i>
            <div>
              <div class="sigma_icon-block-content">
                <span>Send Email <i class="far fa-arrow-right"></i> </span>
                <h5> Email Address</h5>
                @if(!empty($sitesetting->comp_email))
                    <span>
                        <a href="mailto:{{ $sitesetting->comp_email }}" style="color: inherit; text-decoration: none;">
                            {{ $sitesetting->comp_email }}
                        </a>
                    </span>
                @endif
              </div>
              <div class="icon-wrapper">
                <i class="flaticon-email"></i>
              </div>
            </div>
          </div>
        </div>

        <div class="col-lg-4">
          <div class="sigma_icon-block text-center light icon-block-7">
            <i class="flaticon-call"></i>
            <div class="sigma_icon-block-content">
              <span>Call Us Now <i class="far fa-arrow-right"></i> </span>
              <h5> Phone Number </h5>
              @if(!empty($sitesetting->comp_phone))
                  <span>
                      <a href="tel:+91{{ $sitesetting->comp_phone }}" style="color: inherit; text-decoration: none;">
                          <i class="fas fa-phone-alt"></i>+91 {{ $sitesetting->comp_phone }}
                      </a>
                  </span>
              @endif
              <div class="icon-wrapper">
                <i class="flaticon-call"></i>
              </div>
            </div>
          </div>
        </div>

        <div class="col-lg-4">
          <div class="sigma_icon-block text-center light icon-block-7">
            <i class="flaticon-location"></i>
            <div class="sigma_icon-block-content">
              <span>Find Us Here <i class="far fa-arrow-right"></i> </span>
              <h5> Location </h5>
              @if(!empty($sitesetting->comp_address))
                  <span class="address-text">{!! $sitesetting->comp_address !!}</span>
              @endif
              <div class="icon-wrapper">
                <i class="flaticon-location"></i>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
  <!-- Icons End -->


@endsection

