@extends('admin.layout.app')

@section('content')
<style>
.dt-buttons.btn-group {
    position: absolute;
    top: 108px;
    left: 178px;
}
</style>
<div class="main-content app-content">


    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
       
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">VendorPayment Details</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ VendorPayment Details</span>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">

            <div class="d-flex my-xl-auto right-content" style="margin-right: 15px;">
                    <div id="reportrange"  class="date_picker_range">
                        <i class="far fa-calendar-alt"></i>&nbsp;
                        <span>Date Filter</span> <b class="caret"></b>
                        <i class="fas fa-caret-down float-right"></i>
                        <input type="hidden" name="startDate" id="startDate" value="" />
                        <input type="hidden" name="endDate" id="endDate" value="" />
                    </div>
                </div>
				  <div class="pe-1 mb-xl-0">
                    <a href="{{ url('admin/vendorpayment/create') }}"><button type="button" class="btn btn-primary">Add VendorPayment</button></a>
				 </div>
            </div>
        </div>
        <!-- breadcrumb -->

        <!--Row-->
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">VendorPayment Details</h4>
                        </div>
                        <div class="col-sm-4" style="margin-right:20px;margin-left:20px;margin-top: 14px;" >
                            <div class="form-group">
                                <select id="vendor_id" name="vendor_id" class="form-control form-select js-example-basic-multiple" data-bs-placeholder="Customer" style="margin-top:20px;" >
                                            <option value="">---Select Vendor---</option>
                                            @php $vendor = App\Models\Vendor::get();  @endphp
                                            @foreach($vendor as $v)
                                            <option value="{{$v->id}}">{{$v->name."-".$v->mobile}}</option>
                                            @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom" id="example1">
                                <thead>
                                    <tr>
                                        <th ><span>SR</span></th>
                                        <th ><span>Vendor Name</span></th>
                                        <th ><span>Txn Id</span></th>
                                        <th ><span>Amount</span></th>
                                        <th ><span>Payment Mode</span></th>
                                        <th ><span>Payment Date</span></th>
                                        <th ><span>Image</span></th>
                                        <th ><span>Rmarks</span></th>
                                        <th ><span>Status</span></th>
                                        <th >Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div><!-- COL END -->
        </div>
        <!-- row closed  -->
    </div>
    <!-- Container closed -->
</div>
<!-- main-content closed -->



@endsection
@section('js')
<script>
$(document).ready(function () {
	$('.js-example-basic-multiple').select2();
});
jQuery(document).ready(function () {
        var startDate = $('#startDate').val();
        var endDate = $('#endDate').val();
    var oTable = $('#example1').DataTable({
                "responsive": true,
                "lengthChange": true,
                "autoWidth": false,
                "pageLength": 25,
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"],
                processing: true,
                serverSide: true,
                dom: 'lBfrtip',
                ajax: {
                    url: "{{ url('admin/vendorpayment') }}",
                    type: 'get',
                    data: function (d) {
                        d._token = "{{ csrf_token() }}";
                        d.startDate = $('#startDate').val();
                        d.endDate = $('#endDate').val();
                    },
                },
                columns: [
                    {data: 'sr_no', name: 'sr_no', searchable: false, className: 'text-center'},
                    {data: 'vendor.name', name: 'vendor.name', orderable: true, className: 'text-center'},
                    {data: 'txn_id', name: 'txn_id', defaultContent: '-', className: 'text-center'},
                    {data: 'amount', name: 'amount', orderable: false, className: 'text-center'},
                    {data: 'payment_mode', name: 'payment_mode', orderable: false, className: 'text-center'},  
                    {data: 'payment_date', name: 'payment_date', orderable: false, className: 'text-center'},
                    {data: 'image', name: 'image', orderable: false, className: 'text-center'},
                    {data: 'remarks', name: 'remarks', defaultContent: '-', searchable: true, orderable: false, className: 'text-center'},
                    {data: 'status', name: 'status', orderable: false, className: 'text-center'},
                    {data: 'action', name: 'action', searchable: false, orderable: false, className: 'text-center'},
                ]
            });

        $("#vendor_id").on('change', function () {
            // Reload DataTable with new data based on order_no
            var vendor = $(this).val();
            oTable.ajax.url("{{ url('admin/vendorpayment') }}?vendor_id=" + vendor).load();
        });
});
$("body").on("change", "#statusToggle", function () {
    var currentStatus = jQuery(this).data('status');
        if(currentStatus == 'Active'){
            Status = 'Deactive';
        }else{
            Status = 'Active';
        }
    Swal.fire({
        title: "Are you sure?",
        text: "you want to "+Status+" this Employee ?",
        icon: "question",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Yes, confirm it!"
        }).then((result) => {
        if (result.isConfirmed) {
            var id = $(this).data('id');
        
            jQuery.ajax({
                url: "{{ url('admin/vendorpayment') }}/" + id ,
                type: 'PUT',
                data: {
                    "_token": "{{ csrf_token() }}",
                    "id": id,
                    "currentStatus": currentStatus,
                },
                success: function (data) {
                    if(data.result == true)
                        oTable.ajax.reload();
                        toastr.success(data.message);

                    jQuery('#statusToggle').data('status', data.status);
                },
                error: function (xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        }else{
            oTable.DataTable().ajax.reload();
        }
    });   
});
$("#example1").on('click', '.data-delete', function () {
    Swal.fire({
    title: "Are you sure?",
    text: "Do you want to delete this record!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#3085d6",
    cancelButtonColor: "#d33",
    confirmButtonText: "Yes, delete it!"
    }).then((result) => {
        if (result.isConfirmed) {
            var obj = jQuery(this);
            var id = obj.attr('data-id');
            jQuery.ajax({
                type: "POST",
                url: "{{ url('admin/vendorpaymentdelete')  }}/" + id,
                data: {
                    id: id,
                    _token: "{{ csrf_token() }}"
                },
                dataType: 'json',
                beforeSend: function () {
                    obj.attr('disabled', true);
                    jQuery('.alert .msg-content').html('');
                    jQuery('.alert').hide();
                },
                success: function (resp) {
                    if(resp.success == true){
                            window.location.reload();
                            toastr.success(resp.message);
                        }
                }
                
            });
        }
    });
});

    $(function () {    	 
    var start = moment().subtract(29, 'days');
	    var end = moment();
	    $('#reportrange').daterangepicker({
	        startDate: start,
	        endDate: end,
	        ranges: {
	           'Today': [moment(), moment()],
	           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
	           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
	           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
	           'This Month': [moment().startOf('month'), moment().endOf('month')],
	           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
	        }
	    }, 
	    function cb(start, end) {
	        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
	            $('#startDate').val(start.format('DD-MM-YYYY'));
                $('#endDate').val(end.format('DD-MM-YYYY'));
                $('#example1').DataTable().ajax.reload();
	    }
	    )
});
</script>
@endsection