<style>
.input-group-text {
	font-size:1.4rem;
	border-radius:3px;
}
.form-control{
	color: #322a35;
}
</style>
 
 
 <div class="row">
	<div class="col-lg-12 col-md-12 col-md-12">
		<div class="card blog-edit">
			<div class="card-body">
				<div class="form-group">
					<label class="form-label">Vendor Name</label>
					<select name="vendor_id" class="form-control form-select js-example-basic-multiple" data-bs-placeholder="Vendor Name" required="required">
						<option value="">------Select-----</option>
						@foreach($vendor as $v)
							<option value="{{ $v->id }}" {{ old('vendor_id', !empty($vendorpayment) ? $vendorpayment->vendor_id : '') == $v->id ? 'selected' : '' }}> 
								{{ $v->name }}
							</option>
						@endforeach
					</select>
					@error('vendor_id')
					<div style="color:red">{{ $message }}</div>
					@enderror
				</div>
			
				<div class="control-group form-group">
					<label class="form-label">Payment Date</label>
					<div class="input-group">
						<div class="input-group-text">
							<i class="typcn typcn-calendar-outline tx-24 lh--9 op-6"></i>
						</div>
						<input class="form-control fc-datepicker" name="payment_date" id="payment_date" placeholder="DD/MM/YYYY" type="text" value="{{ old('payment_date', !empty($vendorpayment) ? date('d-m-Y', strtotime($vendorpayment->payment_date)) : '') }}">
						@error('payment_date')
						<div style="color:red">{{ $message }}</div>
						@enderror
					</div>
				</div>
			
				<div class="form-group">
					<label class="form-label text-dark">Total Amount</label>
					<input type="text" class="form-control" name="amount" placeholder="Total Amount" title="Please enter valid Amount" required="required" value="{{ old('amount', !empty($vendorpayment) ? $vendorpayment->amount : '') }}">
					@error('amount')
					<div style="color:red">{{ $message }}</div>
					@enderror
				</div>
			
				<div class="form-group">
					<label class="form-label">Mode Of Payment</label>
					<select class="form-control form-select js-example-basic-multiple" name="payment_mode" data-bs-placeholder="Mode Of Payment" required="required">
						<option value="">------Select-----</option>
						<option value="Online Paytm Gateway" {{ old('payment_mode', !empty($vendorpayment) ? $vendorpayment->payment_mode : '') == 'Online Paytm Gateway' ? 'selected' : '' }}>Online Paytm Gateway</option> 
						<option value="Bank Transfer" {{ old('payment_mode', !empty($vendorpayment) ? $vendorpayment->payment_mode : '') == 'Bank Transfer' ? 'selected' : '' }}>Bank Transfer</option>
						<option value="Cash" {{ old('payment_mode', !empty($vendorpayment) ? $vendorpayment->payment_mode : '') == 'Cash' ? 'selected' : '' }}>Cash</option>
						<option value="Paytm" {{ old('payment_mode', !empty($vendorpayment) ? $vendorpayment->payment_mode : '') == 'Paytm' ? 'selected' : '' }}>Paytm</option>
						<option value="Paytm QR" {{ old('payment_mode', !empty($vendorpayment) ? $vendorpayment->payment_mode : '') == 'Paytm QR' ? 'selected' : '' }}>Paytm QR</option>
						<option value="Phone Pay" {{ old('payment_mode', !empty($vendorpayment) ? $vendorpayment->payment_mode : '') == 'Phone Pay' ? 'selected' : '' }}>Phone Pay</option>
						<option value="BHIM UPI" {{ old('payment_mode', !empty($vendorpayment) ? $vendorpayment->payment_mode : '') == 'BHIM UPI' ? 'selected' : '' }}>BHIM UPI</option>
						<option value="JD Pay" {{ old('payment_mode', !empty($vendorpayment) ? $vendorpayment->payment_mode : '') == 'JD Pay' ? 'selected' : '' }}>JD Pay</option>
						<option value="G Pay" {{ old('payment_mode', !empty($vendorpayment) ? $vendorpayment->payment_mode : '') == 'G Pay' ? 'selected' : '' }}>G Pay</option>
					</select>
					@error('payment_mode')
					<div style="color:red">{{ $message }}</div>
					@enderror
				</div>
			
				<div class="form-group">
					<label class="form-label text-dark">TXN ID / Cheque Number</label>
					<input type="text" class="form-control" name="txn_id" placeholder="TXN ID / Cheque Number" value="{{ old('txn_id', !empty($vendorpayment) ? $vendorpayment->txn_id : '') }}">
					@error('txn_id')
					<div style="color:red">{{ $message }}</div>
					@enderror
				</div>
			
				<div class="form-group">
					<label class="form-label text-dark">Payment Remarks</label>
					<textarea class="summernote" id="summernote" name="remarks" rows="5" cols="50" placeholder="Payment Remarks" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;">{{ old('remarks', !empty($vendorpayment) ? $vendorpayment->remarks : '') }}</textarea>
				</div> 
			
				<div class="form-group">
					<label class="form-label text-dark">Upload Image</label>
					<input type="file" name="image" />
					@error('image')
					<div style="color:red">{{ $message }}</div>
					@enderror
				</div>
			</div>
			
		</div>
	</div>
</div>



@section('js')
<script>
$(document).ready(function () {
	$('.js-example-basic-multiple').select2();
});
$(function () {
	$('#payment_date').bootstrapdatepicker({
		autoclose: true,
		format: "dd-mm-yyyy",
		viewMode: "date",
	});

})
 
  
  jQuery(document).ready(function () {
       
        jQuery('.image-input').on('change', function () {
            
            var file = this.files[0];
             var previewId = jQuery(this).data('preview');
             console.log(previewId);
          
            if (file) {
               
                var reader = new FileReader();

              
                reader.onload = function (e) {
                   
                    jQuery('#' + previewId).attr('src', e.target.result);
                };

                
                reader.readAsDataURL(file);
            } else {
               
                jQuery('#' + previewId).attr('src', ''); 
            }
        });
    });
  
  </script>

@endsection