@extends('admin.layout.app')

@section('content')

<div class="main-content app-content">


    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Vendor Product Details</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ Vendor Product Details</span>
                </div>
            </div>
            
            <?php /*
            <div class="d-flex my-xl-auto right-content">
				  <div class="pe-1 mb-xl-0">
                    <a href="{{ url('admin/phone/create') }}"><button type="button" class="btn btn-primary">Add Numbers</button></a>
				 </div>
            </div>  */ ?>
        </div>
        <!-- breadcrumb -->

        <!--Row-->
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                    <div class="row g-2" style="margin-top:20px;">
              
                    <div class="col-sm-4" style="margin-right:20px;margin-left:20px;" >
                    <div class="form-group">
                        <label class="form-label">Vendor Name</label>
                        <select id="vendor_id" class="form-control form-select select2" data-bs-placeholder="Vendor" required="required">
                                   <option value="">-----Select-----</option>
                                   @foreach($vendor as $v)
                                   <option value="{{$v->id}}">{{$v->name}}</option>
                                   @endforeach
                        </select>
                    </div>
                    </div>
                    <div class="col-sm-2" >
                        <div class="form-group">
                     <button type="button" class="btn btn-primary float-end" style="margin-top: 25px;margin-right: 198px;" id="submitBtn">Submit</button>
                </div>
                </div>
               
               
                
            </div> 
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Numbers Details</h4>
                            <input type="hidden" id="status" value="{{$status}}">
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom" id="example1">
                                <thead>
                                    <tr>
                                        <th ><span>SR No</span></th>
                                        <th ><span>Number</span></th>
                                        <th ><span>Sum Total</span></th>
                                        <th ><span>Category</span></th>
                                        <th ><span>Operator / Circle</span></th>
                                        <th ><span>Number Status</span></th>
                                        <th ><span>Rate</span></th>
                                        <th ><span>Discount</span></th>
                                        <th ><span>Vender Rate</span></th>
                                        <th ><span>Vender</span></th>
                                        <th ><span>Update Date</span></th>
                                        <th >Status</th>
                                        <th >Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                            
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div><!-- COL END -->
        </div>
        <!-- row closed  -->
    </div>
    <!-- Container closed -->
</div>
<!-- main-content closed -->



@endsection
@section('js')
<script>
   jQuery(document).ready(function () {
    // $("#example1").DataTable({
    //   "responsive": true, "lengthChange": true, "autoWidth": false,
    //   "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    // }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    function initDataTable() {
    var status = $('#status').val();
    var vendor_id = $('#vendor_id').val();
    var oTable = $('#example1').DataTable({
        responsive: true,
        autoWidth: false,
        stateSave: true,
        processing: true,
        serverSide: true,
        ajax:{ 
            url: "{{ url('admin/vendorproduct') }}",
            type: 'get',
            data: {
                "_token": "{{ csrf_token() }}",
                "vendor_id": vendor_id, // Add a comma here
                "status": status,
            },
        },
        columns: [
            {data: 'sr_no', name: 'sr_no', searchable: false, className: 'text-center'},
            {data: 'actual_number', name: 'actual_number', orderable: false, className: 'text-center'},
            {data: 'total_number', name: 'total_number', orderable: false, className: 'text-center'},
            {data: 'category.name', name: 'category.name', defaultContent: '-', searchable: false, orderable: false},
            {data: 'circle', name: 'circle', orderable: false, className: 'text-center'},
            {data: 'number_status', name: 'number_status', orderable: false, className: 'text-center'},
            {data: 'number_rate', name: 'number_rate', orderable: false, className: 'text-center'},
            {data: 'discount', name: 'discount', orderable: false, className: 'text-center'},
            {data: 'discount', name: 'vendor_rate', orderable: false, className: 'text-center'},
            {data: 'vendor.name', name: 'vendor.name', defaultContent: '-', searchable: false, orderable: false, className: 'text-center'},
            {data: 'updated_at', name: 'updated_at', orderable: false, className: 'text-center'},
            {data: 'status', name: 'status', searchable: false, orderable: false, className: 'text-center'},
            {data: 'action', name: 'action', searchable: false, orderable: false, className: 'text-center'},
        ]
      
    });
    return oTable; 
}



    // $("body").on("change", "#statusToggle", function () {
    //     var id = $(this).data('id');
    //     var currentStatus = jQuery(this).data('status');
    //     jQuery.ajax({
    //         url: "{{ url('admin/phone') }}/" + id ,
    //         type: 'PUT',
    //         data: {
    //             "_token": "{{ csrf_token() }}",
    //             "id": id,
    //             "currentStatus": currentStatus,
    //         },
    //         success: function (data) {
    //             if(data.success == true)
    //             toastr.success(data.message);
    //             jQuery('#statusToggle').data('status', data.status);
    //         },
    //         error: function (xhr, status, error) {
    //             console.error(xhr.responseText);
    //         }
    //     });
    // });

    var oTable = initDataTable();
    jQuery("#submitBtn").on("click", function () {
        oTable.destroy();

            
            oTable = initDataTable();
  });



    $("#example1").on('click', '.data-delete', function () {
            var obj = jQuery(this);
            var id = obj.attr('data-id');
			if (confirm("Are you sure to Delete Data?")) {
				$.ajax({
					type: "DELETE",
					url: "{{ url('admin/phone')  }}/" + id,
					data: {
						id: id,
						_token: "{{ csrf_token() }}"
					},
					dataType: 'json',
					beforeSend: function () {
						$(this).attr('disabled', true);
						$('.alert .msg-content').html('');
						$('.alert').hide();
					},
					success: function (resp) {
						if(resp.success == true){
						    oTable.ajax.reload();
                            toastr.success(resp.message);
                        }
					},
					error: function (e) {
						alert('Error: ' + e);
					}
				});
			}
		});
		
});


</script>
@endsection