@extends('admin.layout.app')
@section('content')

<div class="main-content app-content">
    <div class="main-container container-fluid">
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto">Vendor Payment Status</h4><span class="text-muted mt-1 tx-13 ms-2 mb-0">/ Vendor Payment Status</span>
            </div>
        </div>
    </div>
        <div class="row row-sm">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card  box-shadow-0">
                    <div class="card-header">
                        <h4 class="card-title mb-1">Vendor Payment Status</h4>
                        <p class="mb-2"></p>
                    </div>
                    <form class="form-horizontal" action="{{ url('admin/vendorPaymentStatusUpdate') }}" enctype="multipart/form-data" method="post">                  
                        {{ csrf_field() }}
                        <div class="card-body pt-0">
                            <div class="row">
                                <div class="col-lg-12 col-md-12 col-md-12">
                                    <div class="form-group">
                                        <label class="form-label">Payment Status</label>
                                        <select name="payment_status" class="form-control form-select select2" data-bs-placeholder="Payment Status" required="required">
                                            <option value="">-----Select-----</option>
                                            <option value="Y">PAID</option>
                                            <option value="N">UN PAID</option>	
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">Payment Date</label>
                                        <div class="input-group">
                                            <div class="input-group-text">
                                                <i class="typcn typcn-calendar-outline tx-24 lh--9 op-6"></i>
                                            </div>
                                            <input class="form-control" name="paymentDate" required="required" id="paymentDate" placeholder="MM/DD/YYYY" type="text" >
                                        </div><!-- input-group -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" name="vProductId" id="vProductId" value="{{$vProductId}}">
                        <div class="card-footer ">
                            {{-- <a href="{{url('admin/vendorcredit?vendorid=')}}" class="btn btn-secondary mb-3">Back</a> --}}
                            <button type="submit" class="btn btn-primary float-end mb-3">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
	</div>
</div>

@endsection
@section('js')
<script>
 $(function () {
    $('#paymentDate').bootstrapdatepicker({
        autoclose: true,
        format: "dd-mm-yyyy",
        viewMode: "date",
    });
    
});
</script>
@endsection