@extends('admin.layout.app')

@section('content')
<style>
.dt-buttons.btn-group {
    position: absolute;
    top: 50px;
    left: 178px;
}
</style>

<div class="main-content app-content">


    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Sales Report</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ Sales Report</span>
                </div>
            </div>
            
             <div class="d-flex my-xl-auto right-content">
                <div class="d-flex my-xl-auto right-content" style="margin-right: 15px;">
                    <div id="reportrange"  class="date_picker_range">
                        <i class="far fa-calendar-alt"></i>&nbsp;
                        <span>Date Filter</span> <b class="caret"></b>
                        <i class="fas fa-caret-down float-right"></i>
                        <input type="hidden" name="startDate" id="startDate" value="" />
                        <input type="hidden" name="endDate" id="endDate" value="" />
                    </div>
                </div>
            </div>
        </div>
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Sales Report</h4>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom" id="example1">
                                <thead>
                                    <tr>
                                        <th >SR No</th>
                                        <th >Order ID</th>
                                        <th >Order Date</th>
                                        <th >Number</th>
                                        <th >Name</th>
                                        <th >Mobile No</th>
                                        <th >Assign To</th>
                                        <th >Number Rate</th>
                                        <th >Discount</th>  
                                        <th >Discount Rate</th>
                                        <th >Vender Rate</th>
                                        <th >Vender Name</th>
                                        <th >Order status</th>
                                        <th >Process Status</th>
                                        <th >Address</th>
                                        <th >State</th>
                                        <th >Transection Id</th>
                                        <th >Payment Mode</th>
                                    </tr>
                                </thead>
                                <tbody>
                                   
                                </tbody>
                            </table>
                        </div>
                        <div class="text-center"><b>Total Sale :- {{$number_rate}}&nbsp;&nbsp;Total Purchase :- {{$vendor_rate}}&nbsp;&nbsp;Total Margin :- {{$number_rate-$vendor_rate}}</b></div>
                    </div>
                </div>
            </div><!-- COL END -->
        </div>
    </div>
</div>




@endsection
@section('js')


<script>
jQuery(document).ready(function () {
    // $("#example1").DataTable({
    //   "responsive": true, "lengthChange": true, "autoWidth": false,
    //   "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    // }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    var startDate = $('#startDate').val();
    var endDate = $('#endDate').val();
    var oTable = $('#example1').DataTable({
            "responsive": true, "lengthChange": true, "autoWidth": false, "pageLength": 25,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"],
            processing: true,
            serverSide: true,
            dom:'lBfrtip',
			ajax:{ 
                url: "{{ url('admin/salesReport') }}",
                type: 'get',
                data: function (d) {
                    d._token = "{{ csrf_token() }}";
                    d.startDate = $('#startDate').val();
                    d.endDate = $('#endDate').val();
                },
             },
			columns: [
				{data: 'sr_no', name: 'sr_no', searchable: false,className : 'text-center'},
                {data: 'order_number', name: 'order_number',orderable : false,className : 'text-center'},
                {data: 'order_date', name: 'order_date', searchable: false,orderable : false,className : 'text-center', defaultContent: '-'},
                {data: 'product_name', name: 'product_name',orderable : false,className : 'text-center'},
                {data: 'order.name', name: 'order.name',orderable : false,className : 'text-center'},
               
                {data: 'order.mobile_no', name: 'order.mobile_no', searchable: false,orderable : false,className : 'text-center'},
                {data: 'assign_to', name: 'assign_to',orderable : false,className : 'text-center', defaultContent: '-'},
                {data: 'number_rate', name: 'number_rate', searchable: false,orderable : false,className : 'text-center'},
                {data: 'discount', name: 'discount',orderable : false,className : 'text-center'},
                {data: 'discount_rate', name: 'discount_rate',orderable : false,className : 'text-center'},
				{ data: 'vendor_rate', name: 'vendor_rate', searchable: false,orderable : false ,className : 'text-center'},
				{data: 'vendor.name', name: 'vendor.name', searchable: false,orderable : false,className : 'text-center', defaultContent: '-'},
				{data: 'order_status', name: 'order_status', searchable: false, orderable : false,className : 'text-center'},
                {data: 'status', name: 'status', searchable: false, orderable : false,className : 'text-center'},
                {data: 'address', name: 'address',orderable : false,className : 'text-center'},
                {data: 'state', name: 'state',orderable : false,className : 'text-center'},
                {data: 'transection', name: 'transection',orderable : false,className : 'text-center'},
                {data: 'payment_mode', name: 'payment_mode',orderable : false,className : 'text-center'},
			]
    });
    $("#example1").on('click', '.data-delete', function () {
        Swal.fire({
            title: "Are you sure?",
            text: "Do you want to delete this record!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    var obj = jQuery(this);
                    var id = obj.attr('data-id');
                    $.ajax({
                        type: "DELETE",
                        url: "{{ url('admin/salesReport')  }}/" + id,
                        data: {
                            id: id,
                            _token: "{{ csrf_token() }}"
                        },
                        dataType: 'json',
                        beforeSend: function () {
                            $(this).attr('disabled', true);
                            $('.alert .msg-content').html('');
                            $('.alert').hide();
                        },
                        success: function (resp) {
                            if(resp.success == true){
                                oTable.ajax.reload();
                                toastr.success(resp.message);
                            }
                        },
                        error: function (e) {
                            alert('Error: ' + e);
                        }
                    });
                }
            });
            
    });
		
});
$(function () {    	 
    var start = moment().subtract(29, 'days');
	    var end = moment();
	    $('#reportrange').daterangepicker({
	        startDate: start,
	        endDate: end,
	        ranges: {
	           'Today': [moment(), moment()],
	           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
	           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
	           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
	           'This Month': [moment().startOf('month'), moment().endOf('month')],
	           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
	        }
	    }, 
	    function cb(start, end) {
	        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
	            $('#startDate').val(start.format('DD-MM-YYYY'));
                $('#endDate').val(end.format('DD-MM-YYYY'));
                $('#example1').DataTable().ajax.reload();
	    }
	    )
});
</script>
@endsection