@extends('admin.layout.app')
@section('content')
<style>
.input-group-text {
	font-size:1.4rem;
	border-radius:3px;
}
.form-control{
	color: #322a35;
	border: 1px solid #8bbef !important;
}
.select2-container--default .select2-selection--single{
    border: 1px solid #e1e5ef !important;
	border-radius: 3px !important;
}
span.select2-selection.select2-selection--single{
	height: 35px;
}
#global-loader{
    background: #ffffff9e !important;
}

</style>
<div class="main-content app-content">
    <div class="main-container container-fluid">
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto">Bulk Upload</h4><span class="text-muted mt-1 tx-13 ms-2 mb-0">/ Bulk Upload</span>
            </div>
        </div>
    </div>
        <div class="row row-sm">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card  box-shadow-0">
                    <div class="card-header">
                        <h4 class="card-title mb-1">Bulk Upload</h4>
                        <p class="mb-2"></p>
                    </div>
                    <form class="form-horizontal"  enctype="multipart/form-data" id="bulknumberupload" method="post">
                 
                        <div class="card-body pt-0">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group {{ $errors->has('number_upload') ? ' has-error' : '' }}">
                                    <label for="name" class="form-label text-dark">Number Upload</label>
                                        <input type="file" class="form-control" id="number_upload" placeholder="number_upload" name="number_upload" required>
                                    @error('number_upload')
                                        <div style="color:red">{{ $message }}</div>
                                    @enderror
                                        <div style="color:red" id="error"></div>
                                    </div>
                                    <p>Sample File :- <a href="{{url('assets/admin/BulkDataUpdate_new.csv')}}"> Download Sample File</a></p>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer ">
                            <a href="{{url('admin/phone')}}" class="btn btn-secondary mb-3">Back</a>
                            <button type="button" onclick="bulkupload();" id="submit" class="btn btn-primary float-end mb-3">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
	</div>
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Bulk Upload Number Count</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div class="container-fluid">
            <table class="table">
                <thead class="thead-light">
                  <tr class="text-center">
                    <th scope="col">Correct Number</th>
                    <th scope="col">Wrong Number</th>
                  </tr>
                </thead>
                <tbody>
                  <tr class="text-center">
                    <td id="currect_number"></td>
                    <td id="wrong_number"></td>
                  </tr>
                </tbody>
              </table>
          </div>
        </div>
        <div class="modal-footer">
             <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
</div>
@endsection
@section('js')
<script>
$(document).ready(function () {
    
});
function bulkupload(){
    var number_upload = $('#number_upload').val();
    if (number_upload != '') {
        var formData = new FormData($('#bulknumberupload')[0]);
        jQuery.ajax({
            url: "{{ url('admin/bulkupload') }}",
            type: 'POST',
            contentType: false,
            processData: false,
            data: formData,
            headers: {
                'X-CSRF-TOKEN': "{{ csrf_token() }}"
            },
            beforeSend: function() { 
                $("#submit").prop('disabled', true); 
                $("#global-loader").fadeIn(300);　
            },
            success: function (data) {
                if(data.success == true){
                    $("#global-loader").fadeOut();
                    $("#submit").prop('disabled', false); 
                    $('#bulknumberupload')[0].reset();  
                    toastr.success(data.message);
                    $('#currect_number').text(data.successfullySavedNumbers);
                    $('#wrong_number').text(data.wrongNumbersCount);
                    $('#exampleModal').modal('show');
                }
            },
            error: function (xhr, status, error) {
                console.error(xhr.responseText);
            }
        });
    }else{
        $('#error').text('This field is required.')
    }
}

</script>
@endsection