@extends('admin.layout.app')

@section('content')
<style>
    .dt-buttons.btn-group {
        position: absolute;
        top: 8px;
        left: 178px;
    }
</style>
<div class="main-content app-content">
    <div class="main-container container-fluid">
        <div class="breadcrumb-header justify-content-between">  
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Payment Details</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ Payment Details</span>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
                <div class="row g-2" style="margin-top:20px;">
                    
                </div> 
            </div>
        </div>
        <!-- breadcrumb -->

        <!--Row-->
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Payment Details</h4>
                        </div> 
                        <div class="col-sm-4" style="position: absolute; right: 0; top: 9px;" >
                            <div class="form-group">
                                <select id="customer_id" name="customer_id" class="form-control form-select select2 js-example-basic-multiple mt-5 customer_id" data-bs-placeholder="Customer" style="" >
                                        <option value="">---Select Customer---</option>
                                </select>
                            
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive ">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom" id="example1">
                                <thead>
                                    <tr>
                                        <th >SR</th>
                                        <th >Order ID</th>
                                        <th >Customer Name</th>
                                        <th >Mobile No.</th>
                                        <th >Payment Mode</th>
                                        <th >Card Name</th>
                                        <th>Transection Id</th>
                                        <th >Amount</th>
                                        <th >Image</th>
                                        <th >Payment Date</th>
                                        <th >Status</th>
                                        <th >Remarks</th>
                                        <th >Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                   
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div><!-- COL END -->
        </div>
        <!-- row closed  -->
    </div>
    <!-- Container closed -->
</div>
<!-- main-content closed -->



@endsection
@section('js')
<script>
$(document).ready(function () {
    $('.js-example-basic-multiple').select2();
    function initSelect2() {
        $('.customer_id').select2({
            placeholder: "Select a customer",
            allowClear: true,
            ajax: {
                url: "{{ url('admin/getcustomer_search') }}",
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        q: $.trim(params.term) // search term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data
                    };
                },
                cache: true
            }
        });
        var defaultOption = new Option("Select a customer", "", true, true);
        $('.customer_id').append(defaultOption).trigger('change');
    }

    initSelect2();
    $('.customer_id').on('select2:clear', function (e) {
        $(this).empty();
        initSelect2();
    });
});
   jQuery(document).ready(function () {
    var oTable;
    // Function to initialize DataTable
    function initializeDataTable() {
        oTable = $('#example1').DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "pageLength": 25,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"],
            processing: true,
            serverSide: true,
            dom: 'lBfrtip',
            ajax: {
                url: "{{ url('admin/payment') }}",
                type: 'get',
                data: {
                    "_token": "{{ csrf_token() }}",
                },
            },
            columns: [
                {data: 'sr_no', name: 'sr_no', searchable: false, className: 'text-center'},
                {data: 'order_number', name: 'order_number', orderable: true, className: 'text-center'},
                {data: 'customer_number', name: 'customer_number', defaultContent: '-', className: 'text-center'},
                {data: 'mobile_number', name: 'mobile_number', defaultContent: '-', orderable: false},
                {data: 'payment_mode', name: 'payment_mode', orderable: false, className: 'text-center'},
                {data: 'card_name', name: 'card_name', orderable: false, className: 'text-center'},
                {data: 'txn_id', name: 'txn_id', defaultContent: '-', orderable: false},
                {data: 'amount', name: 'amount', orderable: false, className: 'text-center'},
                {data: 'image', name: 'image', orderable: false, className: 'text-center'},
                {data: 'created_at', name: 'created_at', orderable: false, className: 'text-center'},
                {data: 'status', name: 'status', orderable: false, className: 'text-center'},
                {data: 'remarks', name: 'remarks', defaultContent: '-', searchable: true, orderable: false, className: 'text-center'},
                {data: 'action', name: 'action', searchable: false, orderable: false, className: 'text-center'},
            ]
        });
    }
    initializeDataTable();
    $("#customer_id").on('change', function () {
        var customer = $(this).val();
        oTable.ajax.url("{{ url('admin/payment') }}?customer_id=" + customer).load();
    });

   /* $("body").on("change", "#statusToggle", function () {
        Swal.fire({
            title: "Are you sure?",
            text: "you want to Deactivate this Vendor ?",
            icon: "question",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, confirm it!"
            }).then((result) => {
            if (result.isConfirmed) {
                var id = $(this).data('id');
                var currentStatus = jQuery(this).data('status');
                jQuery.ajax({
                    url: "{{ url('admin/vendor') }}/" + id ,
                    type: 'PUT',
                    data: {
                        "_token": "{{ csrf_token() }}",
                        "id": id,
                        "currentStatus": currentStatus,
                    },
                    success: function (data) {
                        if(data.result == 1)
                        oTable.ajax.reload();
                        toastr.success(data.message);

                        jQuery('#statusToggle').data('status', data.status);
                    },
                    error: function (xhr, status, error) {
                        console.error(xhr.responseText);
                    }
                });
            }else{
                oTable.ajax.reload();
            }
        });   
    });*/

    $("#example1").on('click', '.data-delete', function () {
        Swal.fire({
            title: "Are you sure?",
            text: "Do you want to delete this record?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
            }).then((result) => {
            if (result.isConfirmed) {
                var obj = jQuery(this);
                var id = obj.attr('data-id');
                $.ajax({
                    type: "DELETE",
                    url: "{{ url('admin/payment')  }}/" + id,
                    data: {
                        id: id,
                        _token: "{{ csrf_token() }}"
                    },
                    dataType: 'json',
                    beforeSend: function () {
                        $(this).attr('disabled', true);
                        $('.alert .msg-content').html('');
                        $('.alert').hide();
                    },
                    success: function (resp) {
                        if(resp.success == true){
                            oTable.ajax.reload();
                            toastr.success(resp.message);
                        }
                    },
                    error: function (e) {
                        alert('Error: ' + e);
                    }
                });
            }else{
                oTable.ajax.reload();
            }
        });
    });
		
});

</script>
@endsection