@extends('admin.layout.app')
@section('content')

<style>
  li.select2-selection__choice{
    background: #0162e8 !important;
    padding: 3px 18px !important;
  }
  .select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
    color: #fff !important;
  }
.select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
    opacity: 1 !important;
  }
  
</style>

<div class="main-content app-content">
    <div class="main-container container-fluid">
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto">Order</h4><span class="text-muted mt-1 tx-13 ms-2 mb-0">/ @if(empty($numbers)) New   @else Edit @endif Order</span>
            </div>
        </div>
    </div>
        <div class="row row-sm">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card  box-shadow-0">
                    <div class="card-header">
                        <h4 class="card-title mb-1">@if(empty($order)) New   @else Edit @endif Order</h4>
                        <p class="mb-2"></p>
                    </div>
                    @if(empty($numbers))
                        <form class="form-horizontal" action="{{ url('admin/order') }}" enctype="multipart/form-data" method="post">
                    @else
                        <form class="form-horizontal" action="{{ url('admin/order',$numbers->id) }}" enctype="multipart/form-data" method="post">
                        @method('PUT')
                    @endif	
                    {{ csrf_field() }}
                        <div class="card-body pt-0">
                            @include('admin.order.form')
                        </div>
                        <div class="card-footer ">
                            <a href="{{url()->previous()}}" class="btn btn-secondary mb-3">Back</a>
                            <button type="submit" class="btn btn-primary float-end mb-3">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
	</div>
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add Customer</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="container-fluid">
          <form id="customerform">
            <div class="row">
              <div class="col-md-12">
                <div
                  class="form-group {{ $errors->has('name') ? ' has-error' : '' }}">
                  <label for="name" class="form-label">Customer Name</label>
                  <input type="text" class="form-control" id="inputName" placeholder="Name" name="first_name"
                    value="{{ !empty($customer)?$customer->name:'' }}">
                    <div id="name_error" class="text-danger"></div>
                  @error('name')
                    <div style="color:red">{{ $message }}</div>
                  @enderror
                </div>
              </div>
              <div class="col-md-12">
                <div
                  class="form-group {{ $errors->has('mobile') ? ' has-error' : '' }}">
                  <label for="mobile" class="form-label">Contact Number</label>
                  <input type="text" class="form-control" id="mobile" placeholder="Contact No." name="mobile"
                    value="{{ !empty($customer)?$customer->mobile:'' }}">
                    <div id="mobile_error" class="text-danger"></div>
                  @error('mobile')
                    <div style="color:red">{{ $message }}</div>
                  @enderror
                </div>
              </div>
              <div class="col-md-12">
                <div
                  class="form-group {{ $errors->has('email') ? ' has-error' : '' }}">
                  <label for="name" class="form-label">Email Address</label>
                  <input type="email" class="form-control" id="email" placeholder="Email" name="email"
                    value="{{ !empty($customer)?$customer->email:'' }}">
                    <div id="email_error" class="text-danger"></div>
                  @error('email')
                    <div style="color:red">{{ $message }}</div>
                  @enderror
                </div>
              </div>
              <div class="col-md-12">
                <div class="form-group {{ $errors->has('customer_type') ? ' has-error' : '' }}">
                  <label for="name" class="form-label text-dark">Customer Type</label>
                  <select class="form-control form-select js-example-basic-multiple" id="customer_type" name="customer_type" onchange="toggleCorporateFields();">
                    <option value="Individual"> Individual</option>
                    <option value="Corporate">Corporate</option>
                  </select>
                  <div id="customer_type_error" class="text-danger"></div>
                  @error('customer_type')
                    <div style="color:red">{{ $message }}</div>
                  @enderror
                </div>
              </div>
              <div class="col-md-12">
                <div class="form-group" >
                    <label for="name" class="form-label text-dark">Company Name</label>
                    <input type="text" class="form-control" id="company_name" name="company_name" value="" placeholder="Company Name" required>
                    <div id="company_name_error" class="text-danger"></div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group" >
                    <label for="name" class="form-label text-dark">GST Number</label>
                    <input type="text" class="form-control" id="gst_number" name="gst_number" value="" placeholder="GST Numbe" required>
                    <div id="gst_number_error" class="text-danger"></div>
                </div>
            </div>
              <div class="col-md-12">
                <div class="form-group {{ $errors->has('pincode') ? ' has-error' : '' }}">
                  <label for="name" class="form-label">Pincode</label>
                  <input type="text" class="form-control" id="pincode" placeholder="Pincode" name="pincode"
                    value="{{ !empty($customer)?$customer->pincode:'' }}">
                    <div id="pincode_error" class="text-danger"></div>
                  @error('pincode')
                    <div style="color:red">{{ $message }}</div>
                  @enderror
                </div>
              </div>
              <div class="col-md-12">
                <div  class="form-group {{ $errors->has('address') ? ' has-error' : '' }}">
                  <label for="state" class="form-label">Address</label>
                  <input type="text" class="form-control" id="address" placeholder="Address" name="address"
                    value="{{ !empty($customer)?$customer->address:'' }}">
                    <div id="address_error" class="text-danger"></div>
                  @error('address')
                    <div style="color:red">{{ $message }}</div>
                  @enderror
                </div>
              </div>
              <div class="col-md-12">
                <div class="form-group {{ $errors->has('state') ? ' has-error' : '' }}">
                  <label for="name" class="form-label text-dark">State</label>
                  <select class="form-control form-select js-example-basic-multiple" id="state" name="state">
                    <option value="" selected>Choose One</option>
                    <option value="Andhra Pradesh">Andhra Pradesh</option>
                    <option value="Arunachal Pradesh">Arunachal Pradesh</option>
                    <option value="Assam">Assam</option>
                    <option value="Bihar">Bihar</option>
                    <option value="Chhattisgarh">Chhattisgarh</option>
                    <option value="delhi">Delhi</option>
                    <option value="Goa">Goa</option>
                    <option value="Gujarat">Gujarat</option>
                    <option value="Haryana">Haryana</option>
                    <option value="Himachal Pradesh">Himachal Pradesh</option>
                    <option value="Jammu and Kashmir">Jammu and Kashmir</option>
                    <option value="Jharkhand">Jharkhand</option>
                    <option value="Karnataka">Karnataka</option>
                    <option value="Kerala">Kerala</option>
                    <option value="Madhya Pradesh">Madhya Pradesh</option>
                    <option value="Maharashtra" >Maharashtra</option>
                    <option value="Manipur">Manipur</option>
                    <option value="Meghalaya">Meghalaya</option>
                    <option value="Mizoram">Mizoram</option>
                    <option value="Nagaland">Nagaland</option>
                    <option value="Odisha">Odisha</option>
                    <option value="Punjab">Punjab</option>
                    <option value="Rajasthan">Rajasthan</option>
                    <option value="Sikkim">Sikkim</option>
                    <option value="Tamil Nadu">Tamil Nadu</option>
                    <option value="Telangana">Telangana</option>
                    <option value="Tripura">Tripura</option>
                    <option value="Uttar Pradesh">Uttar Pradesh</option>
                    <option value="Uttarakhand">Uttarakhand</option>
                    <option value="West Bengal">West Bengal</option>
                  </select>
                  <div id="state_error" class="text-danger"></div>
                  @error('state')
                    <div style="color:red">{{ $message }}</div>
                  @enderror
                </div>
                <h4 id="customer_error" class="text-danger"></h4>
              </div>
            </div>
          </form>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary" onclick="customerCheck();">Submit</button>
      </div>
    </div>
  </div>
</div>
@endsection
@section('js')
<script>

</script>
@endsection