@extends('admin.layout.app')
@section('content')
<style>
#global-loader{
    background: #ffffff9e !important;
}
</style>
<div class="main-content app-content">
    <div class="main-container container-fluid">
   <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Orders Export</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ Orders Export</span>
                </div>
            </div>
            
             <div class="d-flex my-xl-auto right-content">
                <div class="d-flex my-xl-auto right-content" style="margin-right: 15px;">
                    <div id="reportrange"  class="date_picker_range">
                        <i class="far fa-calendar-alt"></i>&nbsp;
                        <span>Date Filter</span> <b class="caret"></b>
                        <i class="fas fa-caret-down float-right"></i>
                       
                    </div>
                </div>
            </div>
        </div>
        <div class="row row-sm">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card  box-shadow-0">
                    <div class="card-header">
                        <h4 class="card-title mb-1">Orders Export</h4>
                        <p class="mb-2"></p>
                    </div>
                    <form class="form-horizontal" action="{{url('admin/order_expert')}}" id="myForm" enctype="multipart/form-data" method="post">
                        {{ csrf_field() }}
                        <input type="hidden" name="startDate" id="startDate" value="" />
                        <input type="hidden" name="endDate" id="endDate" value="" />
                        <div class="card-body pt-0">
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="control-group form-group ">
                                        <label class="form-label">Order Id</label>
                                        <div class="input-group">
                                            <input class="form-control " name="order_id" id="order_id" autocomplete="off"  type="text" >
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group ">
                                        <label for="customer_id" class="form-label text-dark">Customer</label>
                                        <select class="form-control form-select customer_id" name="customer_id" id="customer_id" >
                                            <option value="">Choose One</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="control-group form-group ">
                                        <label class="form-label">Mobile No</label>
                                        <div class="input-group">
                                            <input class="form-control " name="mobile_no" id="mobile_no" autocomplete="off"  type="text" >
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="control-group form-group ">
                                        <label class="form-label">Vanity Number</label>
                                        <div class="input-group">
                                            <input class="form-control " name="vanity_number" id="vanity_number" autocomplete="off"  type="text" >
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="control-group form-group ">
                                        <div class="form-group">
                                            <label class="form-label">Status</label>
                                            <select name="status" id="status"  class="form-control form-select js-example-basic-multiple" data-bs-placeholder="Status" >
                                                <!-- <option value="">------Select-----</option> -->
                                                <option value="All" >All</option>
                                                <option value="New" >New</option>
                                                <option value="call_back" >Call Back</option>
                                                <option value="not_contacted" >Not Contacted</option>
                                                <option value="inprocess" >Inprocess</option>
                                                <option value="Follow up" >Follow up</option>
                                                <option value="on_hold" >ON Hold</option>
                                                <option value="closed_won" >Convert to Order</option>
                                                <option value="closed_lost" >Closed Lost</option>
                                                <option value="language_barrier" >Language Barrier</option>
                                                <option value="duplicate">Duplicate</option>
                                                <option value="test" >Test</option>
                                                <option value="cancelled" >Cancelled</option>
                                                <option value="wrong_data" >Wrong Data</option>
                                                <option value="to_be_refund" >To Be Refund</option>
                                                <option value="refund" >Refund</option>
                                                <option value="UPC_Error" >UPC Error</option>
                                                <option value="transfer" >Transfer Order</option>
                                                <option value="teleduce" >Teleduce</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer ">
                            <button type="button" class="btn btn-primary float-end mb-3" id="submit" onclick="orderExpert();">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div id="viewexcel">
			
		</div>
	</div>
</div>
@endsection
@section('js')
<!-- Table2excel -->
<script src="https://raviraj.co.in/raviraj/public/assets/admin/plugins/table2excel/jquery.table2excel.js"></script>

<script>
$(document).ready(function () {
    /*$('#myForm').on('submit', function() {
        $("#submit").prop('disabled', true); 
        $('#global-loader').show();
    });*/
    /*$('#submit').on('click', function() {
        $('#global-loader').show();
        var formData = $('#myForm').serialize();
        fetch($('#myForm').attr('action'), {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: formData
        })
        .then(response => response.blob()) 
        .then(blob => {
            var url = window.URL.createObjectURL(blob);
            var a = document.createElement('a');
            a.href = url;
            a.download = 'orderExpert.csv';
            document.body.appendChild(a);
            a.click();
            a.remove();
            window.URL.revokeObjectURL(url);
        })
        .catch(error => {
            console.error('Error:', error);
        })
        .finally(() => {
            $('#global-loader').hide();
        });
    });*/
    $('.js-example-basic-multiple').select2();
    function initSelect2() {
        $('.customer_id').select2({
            placeholder: "Select a customer",
            allowClear: true,
            ajax: {
                url: "{{ url('admin/getcustomer_search') }}",
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        q: $.trim(params.term) // search term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data
                    };
                },
                cache: true
            }
        });
        var defaultOption = new Option("Select a customer", "", true, true);
        $('.customer_id').append(defaultOption).trigger('change');
    }

    initSelect2();
    $('.customer_id').on('select2:clear', function (e) {
        $(this).empty();
        initSelect2();
    });
  
});
function orderExpert() {
    var status = $('#status').val();
    var order_id = $('#order_id').val();
    var customer_id = $('#customer_id').val();
    var mobile_no = $('#mobile_no').val();
    var vanity_number = $('#vanity_number').val();
    var startDate = $('#startDate').val();
    var endDate = $('#endDate').val();

        $.ajax({
            url: "{{ url('admin/order_expert') }}",
            type: 'post',
            data: {
                _token: "{{ csrf_token() }}",
                order_id: order_id,
                customer_id: customer_id,
                mobile_no: mobile_no,
                vanity_number: vanity_number,
                status: status,
                startDate: startDate,
                endDate: endDate
            },
            beforeSend: function() { 
                $("#submit").prop('disabled', true); 
                $("#global-loader").fadeIn(300);
            },
            success: function(response) {
                $("#submit").prop('disabled', false); 
                toastr.success('Order Expert Successfully');
                $("#global-loader").fadeOut();
                $("#viewexcel").html(response.html);
                $(".table2").table2excel({
                    exclude: ".noExcle",
                    name: "Report",
                    filename: "OrderExpert",
                    fileext: ".xls",
                });
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
            }
        });
}
$(function () {    	 
    var start = moment().subtract(29, 'days');
	    var end = moment();
	    $('#reportrange').daterangepicker({
	        startDate: start,
	        endDate: end,
	        ranges: {
	           'Today': [moment(), moment()],
	           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
	           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
	           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
	           'This Month': [moment().startOf('month'), moment().endOf('month')],
	           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
	        }
	    }, 
	    function cb(start, end) {
	        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
	            $('#startDate').val(start.format('DD-MM-YYYY'));
                $('#endDate').val(end.format('DD-MM-YYYY'));
                // $('#example1').DataTable().ajax.reload();
	    }
	    )
});
</script>
@endsection