@extends('admin.layout.app')
@section('content')
<div class="main-content app-content">
    <div class="main-container container-fluid">
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto">Numbers Export</h4><span class="text-muted mt-1 tx-13 ms-2 mb-0">/ Numbers Export</span>
            </div>
        </div>
    </div>
        <div class="row row-sm">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card  box-shadow-0">
                    <div class="card-header">
                        <h4 class="card-title mb-1">Numbers Export</h4>
                        <p class="mb-2"></p>
                    </div>
                    <form class="form-horizontal" action="{{ url('admin/numberexport') }}" enctype="multipart/form-data" method="post">
                        {{ csrf_field() }}
                        <div class="card-body pt-0">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group {{ $errors->has('category_id') ? ' has-error' : '' }}">
                                        <label for="name" class="form-label text-dark">Category</label>
                                        <select class="form-control form-select js-example-basic-multiple" name="category_id">
                                            <option value="">Choose One</option>
                                            <option value="without_2_4_8">Numberology Without 2 4 8</option>
                                            @foreach($categories as $categorie)
                                                    <option value="{{$categorie->id}}" @if(!empty($numbers)){{$categorie->id == $numbers->category_id  ? 'selected' : ''}}@endif>{{$categorie->name}}</option>
                                            @endforeach
                                            
                                        </select>
                                        @error('category_id')
                                            <div style="color:red">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group {{ $errors->has('product_type') ? ' has-error' : '' }}">
                                    <label for="name" class="form-label text-dark">Product Type</label>
                                        <select class="form-control js-example-basic-multiple" name="product_type">
                                            <option value="">Choose One</option>
                                            <option value="FAVORITES" >FAVORITES</option>
                                            <option value="New" >New Products</option>
                                            <option value="Sale" >On Sale</option>
                                            <option value="Featured">Featured</option>
                                            <option value="None" >None</option>
                                        </select>
                                    @error('product_type')
                                        <div style="color:red">{{ $message }}</div>
                                    @enderror
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group {{ $errors->has('number_status') ? ' has-error' : '' }}">
                                    <label for="name" class="form-label text-dark">Number Status</label>
                                        <select class="form-control js-example-basic-multiple" name="number_status">
                                            <option value="">Choose One</option>
                                            <option value="FRESH" >FRESH</option>
                                            <option value="RTP">RTP</option>
                                            <option value="V2V" >V2V</option>
                                            <option value="I2I">I2I</option>
                                            <option value="A2A">A2A</option>
                                            <option value="Pretopost">PRE TO POST</option>
                                            <option value="Posttopre">POST TO PRE</option>
                                            <option value="C CODE RTP">C CODE RTP</option>
                                            <option value="Non RTP">Non RTP</option>
                            
                                        </select>
                                    @error('number_status')
                                        <div style="color:red">{{ $message }}</div>
                                    @enderror
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group {{ $errors->has('vendor_id') ? ' has-error' : '' }}">
                                    <label for="name" class="form-label text-dark">Vendor Name</label>
                                        <select class="form-control js-example-basic-multiple" name="vendor_id">
                                            <option value="">Choose One</option>
                                            @foreach($vendors as $vendor)
                                                    <option value="{{$vendor->id}}" @if(!empty($numbers)){{$vendor->id == $numbers->vendor_id  ? 'selected' : ''}}@endif>{{$vendor->name}}</option>
                                            @endforeach
                                        </select>
                                    @error('vendor_id')
                                    <div style="color:red">{{ $message }}</div>
                                    @enderror
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group {{ $errors->has('status') ? ' has-error' : '' }}">
                                        <label class="form-label">Status</label>
                                        <select name="status" class="form-control js-example-basic-multiple" required>
                                            <option value="">Choose Ones</option>
                                            <option value="ALL">ALL</option>
                                            <option value="Available">Available</option>
                                            <option value="Hold">Hold</option>
                                            <option value="Sold">Sold</option>
                                            <option value="sold_by_vendor">Sold By Vendor</option>
                                            <option value="not_available">Not Available</option>
                                            <option value="vendor_deactivated">Vendor Deactivated</option>
										</select>
                                    @error('status')
                                        <div style="color:red">{{ $message }}</div>
                                    @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer ">
                            <button type="submit" class="btn btn-primary float-end mb-3">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
	</div>
</div>
@endsection
@section('js')
<script>
$(document).ready(function () {
    $('.js-example-basic-multiple').select2();
});
</script>
@endsection