@extends('admin.layout.app')
@section('content')
<style>
#global-loader{
    background: #ffffff9e !important;
}
.datepicker{
    z-index: 10 !important;
}
</style>
<div class="main-content app-content">
    <div class="main-container container-fluid">
   <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Gst Export</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ Gst Export</span>
                </div>
            </div>
            
            {{-- <div class="d-flex my-xl-auto right-content">
                <div class="d-flex my-xl-auto right-content" style="margin-right: 15px;">
                    <div id="reportrange"  class="date_picker_range">
                        <i class="far fa-calendar-alt"></i>&nbsp;
                        <span>Date Filter</span> <b class="caret"></b>
                        <i class="fas fa-caret-down float-right"></i>
                       
                    </div>
                </div>
            </div> --}}
        </div>
        <div class="row row-sm">
            <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                <div class="card  box-shadow-0">
                    <div class="card-header">
                        <h4 class="card-title mb-1">Gst Export</h4>
                        <p class="mb-2"></p>
                    </div>
                    <form class="form-horizontal" action="{{url('admin/gst_expert')}}" id="myForm" enctype="multipart/form-data" method="post">
                        {{ csrf_field() }}
                        <div class="card-body pt-0">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="control-group form-group {{ $errors->has('start_date') ? ' has-error' : '' }}">
                                        <label class="form-label">Start Date</label>
                                        <div class="input-group">
                                            <div class="input-group-text">
                                                <i class="typcn typcn-calendar-outline tx-24 lh--9 op-6"></i>
                                            </div>
                                            <input class="form-control date text-black" name="start_date" value="" id="start_date" autocomplete="off" data-format="dd-MM-yyyy HH:mm:ss PP" placeholder="MM/DD/YYYY" type="text">
                                        </div>
                                        @error('start_date')
                                            <div style="color:red">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="control-group form-group {{ $errors->has('end_date') ? ' has-error' : '' }}">
                                        <label class="form-label">End Date</label>
                                        <div class="input-group">
                                            <div class="input-group-text">
                                                <i class="typcn typcn-calendar-outline tx-24 lh--9 op-6"></i>
                                            </div>
                                            <input class="form-control date text-black" name="end_date" value="" id="end_date" autocomplete="off" data-format="dd-MM-yyyy HH:mm:ss PP" placeholder="MM/DD/YYYY" type="text">
                                        </div>
                                        @error('end_date')
                                            <div style="color:red">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer ">
                            <button type="submit" class="btn btn-primary float-end mb-3" id="submit">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
	</div>
</div>
@endsection
@section('js')
<script>
$(document).ready(function () {
   
$(function () {
    $('.date').bootstrapdatepicker({
        autoclose: true,
        format: "dd-mm-yyyy",
        viewMode: "date",
        todayHighlight: true
    });

})
  
});

$(function () {    	 
    var start = moment().subtract(29, 'days');
	    var end = moment();
	    $('#reportrange').daterangepicker({
	        startDate: start,
	        endDate: end,
	        ranges: {
	           'Today': [moment(), moment()],
	           'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
	           'Last 7 Days': [moment().subtract(6, 'days'), moment()],
	           'Last 30 Days': [moment().subtract(29, 'days'), moment()],
	           'This Month': [moment().startOf('month'), moment().endOf('month')],
	           'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
	        }
	    }, 
	    function cb(start, end) {
	        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
	            $('#startDate').val(start.format('DD-MM-YYYY'));
                $('#endDate').val(end.format('DD-MM-YYYY'));
                // $('#example1').DataTable().ajax.reload();
	    }
	    )
});
</script>
@endsection