@extends('admin.layout.app')

@section('content')

<div class="main-content app-content">
	<div class="main-container container-fluid">
		<div class="breadcrumb-header justify-content-between">
			<div class="my-auto">
				<div class="d-flex">
					<h4 class="content-title mb-0 my-auto">Enquiry Details</h4><span class="text-muted mt-1 tx-13 ms-2 mb-0">/ View Enquiry Details</span>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-xxl-9 col-xl-12 col-lg-12 col-md-12">
			<div class="">
					<div class="card">
						<div class="card-header border-bottom-0">
							<h3 class="card-title">Enquiry Details</h3>
						</div>
						<div class="card-body">
							<div class="table-responsive" style="height:300px; overflow:scroll;">
							<table class="table table-bordered border text-nowrap mb-0" id="basic-edit">
							<thead>
							<tr>
								<th>ID</th>
								<th>Type</th>
								<th>Request</th>
								<!-- <th>Email</th>
								<th>Mobile</th> -->
								<th>Description</th>
								<th>Budget</th>
								<th>Source</th>
								<th>Date</th>
							</tr>
							</thead>
							<tbody>
							@php $sr = 0; @endphp
							@foreach($enquiries as $e)
							@php  $sr++;  @endphp
							<tr>
								<td class="center">{{$sr}}</td>
							
								<td class="center">Vanity Number</td>
								
								<td class="center d-flex " style="justify-content:space-between; color:blue;">
									<!-- <a onclick="window.open('viewNumberDetails?Number=8650986504&address=ordershipping', '_blank', 'height=500, width=550, left=150, top=150,  titlebar=no, toolbar=no, addressbar=no, menubar=no, location=no, resizable=no');" href="#"> -->
										{{$e->product_number}}
										<!-- @if($e->status == 'New')
											<span><b>{{$e->status}}</b></span>
										@endif -->
								</td> 
								
								<!-- <td class="center">{{$e->email}}</td>
								<td class="center">{{$e->mobile}}</td> -->
								<td class="center">{{$e->enquery_description}}</td>
								<td class="center"></td>
								<td class="center"></td>
								<td class="center">{{$e->created_at}}</td>
								
							</tr>
							@endforeach
								
							</tbody>
							</table>
						</div>
						</div>
					</div>
				</div>
				
				<div class="">
					<div class="card">
						<div class="card-header border-bottom-0">
							<h3 class="card-title">Order Details</h3>
						</div>
						<div class="card-body">
							<div class="table-responsive" style="height:300px; overflow:scroll;">
							<table class="table table-bordered border text-nowrap mb-0" id="basic-edit">
							<thead>
							
							<tr>
								<th>ID</th>
								<th>Order Id</th>
								<th>Comment By</th>
								<th>Order Comment</th>
								<th>Date</th>
							</tr>
							</thead>
							<tbody>
							@php 
								$sr = 0; 
							@endphp
							@foreach($order as $o)
								@php  
									$sr++;  
								@endphp
								<tr>
									<td class="center">{{$sr}}</td>
									<td class="center">{{$o->order_number}}</td>
									@php 
										$order_activity = App\Models\OrderActivity::with('employee')->where('order_activity.order_id',$o->id)->select('order_activity.*')->first(); 
									@endphp
									<td class="center">{{$order_activity->employee->name??""}}</td>
									<td class="center">{!!$order_activity->remark??"" !!}</td>
									<td class="center">{{$order_activity->created_at??""}}</td>
								</tr>
							@endforeach
								
							</tbody>
							</table>
						</div>
						</div>
					</div>
				</div>

				<div class="">
					<div class="card">
						<div class="card-header border-bottom-0">
							<h3 class="card-title">Recent Activity</h3>
						</div>
						<div class="card-body">
							<div class="table-responsive" style="height:300px; overflow:scroll;">
							<table class="table table-bordered border text-nowrap mb-0" id="basic-edit">
								<thead>
									<tr>
										<th>ID</th>
										<th>Comment By</th>
										<th>Enquiry Comment</th>
										<th>Date</th>
											
									</tr>
								</thead>
								<tbody>
									@php 
										$sr = 0;
										$comment = App\Models\Comment::with('employee')->whereIn('comments.enquiry_id',$enquirie_id)->select('comments.*')->get(); 
									@endphp       
									@if($comment) 
										
										@foreach($comment as $c)  
											@php  $sr++;  @endphp        
											<tr>
												<td class="center">{{$sr}}</td>
												<td class="center">{{$c->employee->name??""}}</td>
												<td class="center">{{strip_tags($c->enquiry_comment)}}</td>
												<td class="center">{{$c->created_at}}</td>
											</tr>
										@endforeach
									@endif
								</tbody>
							</table>
						</div>
						</div>
					</div>
				</div>

				<div class="">
					<div class="card">
						<div class="card-header border-bottom-0">
							<h3 class="card-title">Add a Comment</h3>
						</div>
						<div class="card-body">
							<div class="mt-2">
								
							<form  action="{{url('admin/addcomment')}}"  method="post" name="form">
								<!-- row -->
								{{ csrf_field() }}           
								<input type="hidden" name="enquiry_id" value="{{$enquiry->id}}">
								<input type="hidden" name="user_id" value="{{$enquiry->user_id}}">
									@php
										$com = App\Models\Comment::where('enquiry_id',$enquiry->id)->orderBy('id','DESC')->first();
									@endphp
									<div class="form-group">
										<label class="form-label">Assign TO</label>
										<select name="employee_id" class="form-control form-select select2" data-bs-placeholder="Assign TO" required="required">
											<option value="">------Select-----</option>
											@php  $admin = App\Models\Admin::where('Is_employee',1)->get();  @endphp
											@foreach($admin as $a)
												<option value="{{$a->id}}" {{$com->employee_id??'' == $a->id ?'selected':''}}>{{$a->name}}</option>
												
												@endforeach
												
										</select>
									</div>
									<div class="form-group">
										<label class="form-label">Status</label>
										<select name="status"  class="form-control form-select select2" data-bs-placeholder="Status" required="required">
											<option value="">------Select-----</option>
											<option value="New" {{$com->status??'' == 'New' ?'selected':''}}>New</option>
											<option value="Not Contacted" {{$com->status??'' == 'Not Contacted' ?'selected':''}}>Not Contacted</option>
											<option value="Call Back" {{$com->status??'' == 'Call Back' ?'selected':''}}>Call Back</option>
											<option value="Inprocess" {{$com->status??'' == 'Inprocess' ?'selected':''}}>Inprocess</option>
											<option value="Follow up" {{$com->status??'' == 'Follow up' ?'selected':''}}>Follow up</option>
											<option value="ON Hold" {{$com->status??'' == 'ON Hold' ?'selected':''}}>ON Hold</option>
											<option value="Closed Won" {{$com->status??'' == 'Closed Won' ?'selected':''}}>Convert to Order</option>
											<option value="Closed Lost" {{$com->status??'' == 'Closed Lost' ?'selected':''}}>Closed Lost</option>
											<option value="Language Barrier" {{$com->status??'' == 'Language Barrier' ?'selected':''}}>Language Barrier</option>
											<option value="Duplicate" {{$com->status??'' == 'Duplicate' ?'selected':''}}>Duplicate</option>
											<option value="Test" {{$com->status??'' == 'Test' ?'selected':''}}>Test</option>
											<option value="Cancelled" {{$com->status??'' == 'Cancelled' ?'selected':''}}>Cancelled</option>
											<option value="Wrong Data" {{$com->status??'' == 'Wrong Data' ?'selected':''}}>Wrong Data</option>
										</select>
									</div>											
									<div class="form-group">
										<textarea class="summernote" id="summernote" name="enquiry_comment" rows="5" cols="50" placeholder="Message" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;" required></textarea>
									</div>
									<button type="submit" class="btn btn-primary float-end">Submit</button>
								</form>
								
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-xxl-3 col-xl-12 col-lg-12 col-md-12">
				<div class="card custom-card overflow-hidden">
					<div class="card-header border-bottom">
						<h3 class="card-title">About Customer</h3>
					</div>
					<div class="card-body">
						<div class="text-center">
							<div class="text-justify">
								<p>
									Customer Name: <strong><input type="text" class="form-control text-black" name="custNme" value="{{$enquiry->first_name}}" readonly></strong> <br>
									Phone:<strong><input type="text" class="form-control text-black " name="custNme" value="{{$enquiry->mobile}}" readonly></strong><br>
									Email:<strong><input type="text" class="form-control text-black" name="custNme" value="{{$enquiry->email}}" readonly></strong><br>      
									Address:<strong><input type="text" class="form-control text-black" name="custNme" value="{{$enquiry->customer->address}}" readonly></strong><br>
									State:<strong><input type="text" class="form-control text-black" name="custNme" value="{{$enquiry->customer->state}}" readonly></strong><br>
									Pincode:<strong><input type="text" class="form-control text-black" name="custNme" value="{{$enquiry->customer->pincode}}" readonly></strong><br>
								</p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection
@section('js')
<script>
	$(document).ready(function() {
		$('.select2').select2();
	});
</script>
@endsection
