<style>
.input-group-text {
	font-size:1.4rem;
	border-radius:3px;
}
.form-control{
	color: #322a35;
}
</style>
<div class="row">

    {{-- Name --}}
    <div class="col-md-8 offset-md-2">
        <div class="form-group {{ $errors->has('name') ? ' has-error' : '' }}">
            <label for="name" class="form-label text-dark">Name <span class="text-danger">*</span></label>
            <input type="text" name="name" class="form-control" id="name" placeholder="Enter name" 
                   value="{{ old('name', $education->name ?? '') }}">
            @error('name')
                <div style="color:red">{{ $message }}</div>
            @enderror
        </div>
    </div>

    {{-- Title --}}
    <div class="col-md-8 offset-md-2">
        <div class="form-group {{ $errors->has('title') ? ' has-error' : '' }}">
            <label for="title" class="form-label text-dark">Title <span class="text-danger">*</span></label>
            <input type="text" name="title" class="form-control" id="title" placeholder="Enter title" 
                   value="{{ old('title', $education->title ?? '') }}">
            @error('title')
                <div style="color:red">{{ $message }}</div>
            @enderror
        </div>
    </div>

    {{-- Description --}}
    <div class="col-md-8 offset-md-2">
        <div class="form-group {{ $errors->has('description') ? ' has-error' : '' }}">
            <label for="description" class="form-label text-dark">Description <span class="text-danger">*</span></label>
            <textarea name="description" class="form-control" id="description" placeholder="Enter description">{{ old('description', $education->description ?? '') }}</textarea>
            @error('description')
                <div style="color:red">{{ $message }}</div>
            @enderror
        </div>
    </div>

    {{-- Image 1 --}}
    <div class="col-md-8 offset-md-2">
        <div class="form-group {{ $errors->has('image1') ? ' has-error' : '' }}">
            <label for="image1" class="form-label text-dark">Image 1 <span class="text-danger">{{ !empty($education) ? '' : '*' }}</span></label>
            <input type="file" name="image1" class="form-control image-input" id="image1" data-preview="image1-preview">
            @error('image1')
                <div style="color:red">{{ $message }}</div>
            @enderror
            @if(!empty($education) && !empty($education->image1))
                <img class="form-group image-preview" id="image1-preview" 
                     src="{{ asset($education->image1) }}" 
                     style="width:150px; height:150px;">
            @endif
        </div>
    </div>

    {{-- Image 2 --}}
    <div class="col-md-8 offset-md-2">
        <div class="form-group {{ $errors->has('image2') ? ' has-error' : '' }}">
            <label for="image2" class="form-label text-dark">Image 2</label>
            <input type="file" name="image2" class="form-control image-input" id="image2" data-preview="image2-preview">
            @error('image2')
                <div style="color:red">{{ $message }}</div>
            @enderror
            @if(!empty($education) && !empty($education->image2))
                <img class="form-group image-preview" id="image2-preview" 
                    src="{{ asset($education->image2) }}" style="width:150px; height:150px;">
            @endif
        </div>
    </div>

    {{-- Image 3 --}}
    <div class="col-md-8 offset-md-2">
        <div class="form-group {{ $errors->has('image3') ? ' has-error' : '' }}">
            <label for="image3" class="form-label text-dark">Image 3</label>
            <input type="file" name="image3" class="form-control image-input" id="image3" data-preview="image3-preview">
            @error('image3')
                <div style="color:red">{{ $message }}</div>
            @enderror
            @if(!empty($education) && !empty($education->image3))
                <img class="form-group image-preview" id="image3-preview" 
                     src="{{ asset($education->image3) }}" 
                     style="width:150px; height:150px;">
            @endif
        </div>
    </div>
</div>

<script>
    var hasEducation = @json(!empty($education));
</script>
@section('js')
<script>
jQuery(function(e){
    'use strict';
    $(document).ready(function() {
        $('#description').summernote();
        
    });
});
jQuery(document).ready(function () {       
    jQuery('.image-input').on('change', function () {            
        var file = this.files[0];
            var previewId = jQuery(this).data('preview');
            console.log(previewId);          
        if (file) {               
            var reader = new FileReader();              
            reader.onload = function (e) {                   
                jQuery('#' + previewId).attr('src', e.target.result);
            };                
            reader.readAsDataURL(file);
        } else {               
            jQuery('#' + previewId).attr('src', ''); 
        }
    });
});
  </script>
@endsection