@extends('admin.layout.app')

@section('content')

<div class="main-content app-content">


    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Commission Details</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ View Commission</span>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
				  <div class="pe-1 mb-xl-0">
                    <a href="{{ url('admin/commission/create') }}"><button type="button" class="btn btn-primary">Add Commission</button></a>
				 </div>
            </div>
        </div>
        <!-- breadcrumb -->

        <!--Row-->
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Commission Details</h4>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom" id="example1">
                                <thead>
                                    <tr>
                                        <th >ID</th>
                                        <th >From Amount</th>
                                        <th >To Amount</th>
                                        <th >Commission %</th>
                                        <th >Commission Flat</th>
                                        <th >Create Date</th>
                                        <th >Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                            
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div><!-- COL END -->
        </div>
        <!-- row closed  -->
    </div>
    <!-- Container closed -->
</div>
<!-- main-content closed -->



@endsection
@section('js')
<script>
   jQuery(document).ready(function () {
    // $("#example1").DataTable({
    //   "responsive": true, "lengthChange": true, "autoWidth": false,
    //   "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    // }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    var oTable = $('#example1').DataTable({
			responsive: true,
			autoWidth: false,
			stateSave: true,
			processing: true,
			serverSide: true,
			ajax: "{{ url('admin/commission')  }}",
			columns: [
				{data: 'id', name: 'id', searchable: false,className : 'text-center'},
                {data: 'from_amount', name: 'from_amount',orderable : false,className : 'text-center'},
                {data: 'to_amount', name: 'to_amount',orderable : false,className : 'text-center'},
				{ data: 'commission', name: 'commission', defaultContent: '-', searchable: false,orderable : false },
                {data: 'commission_flat', name: 'commission_flat',orderable : false,className : 'text-center'},
                {data: 'created_at', name: 'created_at',orderable : false,className : 'text-center'},
				{data: 'action', name: 'action', searchable: false, orderable : false,className : 'text-center'},
			]
    });

    $("#example1").on('click', '.data-delete', function () {
            var obj = jQuery(this);
            var id = obj.attr('data-id');
			if (confirm("Are you sure to Delete Data?")) {
				$.ajax({
					type: "DELETE",
					url: "{{ url('admin/commission')  }}/" + id,
					data: {
						id: id,
						_token: "{{ csrf_token() }}"
					},
					dataType: 'json',
					beforeSend: function () {
						$(this).attr('disabled', true);
						$('.alert .msg-content').html('');
						$('.alert').hide();
					},
					success: function (resp) {
						if(resp.success == true){
						    oTable.ajax.reload();
                            toastr.success(resp.message);
                        }
					},
					error: function (e) {
						alert('Error: ' + e);
					}
				});
			}
		});
		
});

</script>
@endsection