<style>
.input-group-text {
	font-size:1.4rem;
	border-radius:3px;
}
.form-control{
	color: #322a35;
}
</style>
    <div class="row">
		<div class="col-md-6">
			<div class="form-group {{ $errors->has('image') ? ' has-error' : '' }}">
				<label for="firm_name" class="form-label text-dark">Upload Image</label>
				<input type="file" class="form-control image-input" id="image" name="image" accept="image/*">
				<img class="form-group image-preview mt-2" id="imagePreview" src="{{ $gallery && $gallery->image ? $gallery->image_url : '' }}" style="width:150px; {{ empty($gallery->image) ? 'display:none;' : '' }}">
				@error('image')
					<div style="color:red">{{ $message }}</div>
				@enderror
			</div>
		</div>
		
    </div>
@section('js')
<script>

  
jQuery(document).ready(function () {
       
	jQuery('.image-input').on('change', function () {
		
		var file = this.files[0];
			var previewId = jQuery(this).data('preview');
			console.log(previewId);
		
		if (file) {   
			
			var reader = new FileReader();

			
			reader.onload = function (e) {
				
				jQuery('#' + previewId).attr('src', e.target.result);
			};

			
			reader.readAsDataURL(file);
		} else {
			
			jQuery('#' + previewId).attr('src', ''); 
		}
	});
});
  
  </script>

@endsection