@extends('admin.layout.app')

@section('content')

<div class="main-content app-content">


    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="my-auto">
                <div class="d-flex">
                    <h4 class="content-title mb-0 my-auto">Blog Details</h4><span
                        class="text-muted mt-1 tx-13 ms-2 mb-0">/ View Blogs</span>
                </div>
            </div>
            <div class="d-flex my-xl-auto right-content">
				  <div class="pe-1 mb-xl-0">
                    <a href="{{ url('admin/blog/create') }}"><button type="button" class="btn btn-primary">Add Blog</button></a>
				 </div>
            </div>
        </div>
        <!-- breadcrumb -->

        <!--Row-->
        <div class="row row-sm">
            <div class="col-sm-12 col-md-12 col-lg-12 col-xl-12 grid-margin">
                <div class="card">
                    <div class="card-header pb-0">
                        <div class="d-flex justify-content-between">
                            <h4 class="card-title mg-b-0">Blog TABLE</h4>
                        </div>
                        <p class="tx-12 tx-gray-500 mb-2"></p>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="border-top-0  table table-bordered key-buttons border-bottom" id="blogDataTable">
                                <thead>
                                    <tr>
                                        <th class="wd-lg-8p"><span>Title</span></th>
                                        <th class="wd-lg-20p"><span>Image</span></th>
                                        <th class="wd-lg-20p"><span>Status</span></th>
                                        <th class="wd-lg-20p">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
								@foreach($result as $r)
                                    <tr>
									
                                        <td>
										{{ $r->name }}
                                        </td>
                                        <td><img src="{{$r->image_url??""}}"></td>
                                        <td>
                                            <div class="form-check form-switch">
                                                <input class="form-check-input blogStatusToggle" style="margin:auto;"
                                                    type="checkbox" role="switch"
                                                    data-id="{{ $r->id }}"
                                                    data-status="{{ $r->status }}"
                                                    {{ $r->status == 'Active' ? 'checked' : '' }}>

											  <label class="form-check-label" for="blogStatusToggle"></label>
											</div>
                                        </td>
                                       
                                        
                                        <td>
                                            <a href="{{url('admin/blog/'.$r->id.'/edit')}}" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit">
                                                <i class="fe fe-edit"></i>
                                            </a>
                                            <button  class="btn btn-sm btn-danger data-delete" data-id="{{$r->id}}"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete">
                                                <i class="fe fe-trash-2"></i>
                                            </button>
                                        </td>
										
                                    </tr>
									@endforeach
                                </tbody>
                            </table>
                        </div>
						{{ $result->links() }}
                    </div>
                </div>
            </div><!-- COL END -->
        </div>
        <!-- row closed  -->
    </div>
    <!-- Container closed -->
</div>
<!-- main-content closed -->



@endsection
@section('js')
<script>
    $("#blogDataTable").DataTable({
      "responsive": true, "lengthChange": true, "autoWidth": false,"pageLength": 25,
      
    });
    jQuery(document).ready(function () {
        jQuery('.blogStatusToggle').change(function () {
            var checkbox = jQuery(this);
            var id = checkbox.data('id');
            var currentStatus = checkbox.data('status');

            jQuery.ajax({
                url: "{{ url('admin/blog') }}/" + id,
                type: 'POST', // Use POST and send _method: PUT
                data: {
                    _token: "{{ csrf_token() }}",
                    _method: "PUT",
                    id: id,
                    currentStatus: currentStatus
                },
                success: function (response) {
                    if (response.success) {
                        // Update the checkbox's data-status attribute
                        checkbox.data('status', response.newStatus);
                    } else {
                        alert("Something went wrong!");
                        checkbox.prop('checked', currentStatus === 'Active'); // revert if error
                    }
                },
                error: function (xhr) {
                    console.error(xhr.responseText);
                    checkbox.prop('checked', currentStatus === 'Active'); // revert if AJAX fails
                }
            });
        });

        jQuery(".data-delete").on("click", function () {
            var obj = jQuery(this);
            var id = obj.attr('data-id');

            if (confirm("Are you sure to Delete Data?")) {
                jQuery.ajax({
                    type: "POST",
                    url: "{{ url('admin/blogdelete')  }}/" + id,
                    data: {
                        id: id,
                        _token: "{{ csrf_token() }}"
                    },
                    dataType: 'json',
                    beforeSend: function () {
                        // Use the stored reference to the clicked element
                        obj.attr('disabled', true);
                        jQuery('.alert .msg-content').html('');
                        jQuery('.alert').hide();
                    },
                    success: function (resp) {
                        if(resp == 1)
                        {
                        window.location.reload();
                        }
                    }
                    
                });
            }
        });
		
    });

</script>
@endsection