(function(){'use strict'
  var keyCounter=0
  var allWaypoints={}
  function Waypoint(options){if(!options){throw new Error('No options passed to Waypoint constructor')}
  if(!options.element){throw new Error('No element option passed to Waypoint constructor')}
  if(!options.handler){throw new Error('No handler option passed to Waypoint constructor')}
  this.key='waypoint-'+keyCounter
  this.options=Waypoint.Adapter.extend({},Waypoint.defaults,options)
  this.element=this.options.element
  this.adapter=new Waypoint.Adapter(this.element)
  this.callback=options.handler
  this.axis=this.options.horizontal?'horizontal':'vertical'
  this.enabled=this.options.enabled
  this.triggerPoint=null
  this.group=Waypoint.Group.findOrCreate({name:this.options.group,axis:this.axis})
  this.context=Waypoint.Context.findOrCreateByElement(this.options.context)
  if(Waypoint.offsetAliases[this.options.offset]){this.options.offset=Waypoint.offsetAliases[this.options.offset]}
  this.group.add(this)
  this.context.add(this)
  allWaypoints[this.key]=this
  keyCounter+=1}
  Waypoint.prototype.queueTrigger=function(direction){this.group.queueTrigger(this,direction)}
  Waypoint.prototype.trigger=function(args){if(!this.enabled){return}
  if(this.callback){this.callback.apply(this,args)}}
  Waypoint.prototype.destroy=function(){this.context.remove(this)
  this.group.remove(this)
  delete allWaypoints[this.key]}
  Waypoint.prototype.disable=function(){this.enabled=!1
  return this}
  Waypoint.prototype.enable=function(){this.context.refresh()
  this.enabled=!0
  return this}
  Waypoint.prototype.next=function(){return this.group.next(this)}
  Waypoint.prototype.previous=function(){return this.group.previous(this)}
  Waypoint.invokeAll=function(method){var allWaypointsArray=[]
  for(var waypointKey in allWaypoints){allWaypointsArray.push(allWaypoints[waypointKey])}
  for(var i=0,end=allWaypointsArray.length;i<end;i++){allWaypointsArray[i][method]()}}
  Waypoint.destroyAll=function(){Waypoint.invokeAll('destroy')}
  Waypoint.disableAll=function(){Waypoint.invokeAll('disable')}
  Waypoint.enableAll=function(){Waypoint.Context.refreshAll()
  for(var waypointKey in allWaypoints){allWaypoints[waypointKey].enabled=!0}
  return this}
  Waypoint.refreshAll=function(){Waypoint.Context.refreshAll()}
  Waypoint.viewportHeight=function(){return window.innerHeight||document.documentElement.clientHeight}
  Waypoint.viewportWidth=function(){return document.documentElement.clientWidth}
  Waypoint.adapters=[]
  Waypoint.defaults={context:window,continuous:!0,enabled:!0,group:'default',horizontal:!1,offset:0}
  Waypoint.offsetAliases={'bottom-in-view':function(){return this.context.innerHeight()-this.adapter.outerHeight()},'right-in-view':function(){return this.context.innerWidth()-this.adapter.outerWidth()}}
  window.Waypoint=Waypoint}())