<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;
use View;
use App\Models\Sitesetting;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */

    public function boot(): void
    {
        $sitesetting = Sitesetting::first();
        View::share('sitesetting', $sitesetting);
    
        if ($this->app->environment('production')) {
            \URL::forceScheme('https');
        }
    
        Route::middleware('web')
            ->group(base_path('routes/web.php'));
    
        Route::middleware('web')
            ->group(base_path('routes/admin.php'));
    }


}
