<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Testimonial extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'testimonials';
    protected $fillable = [
        'name',
        'designation',
		'slug',
        'description',
		'image',
        'status'
    ];
	
	protected $appends = ['image_url'];

	

		public function getImageUrlAttribute($value)

    {

        return  !empty($this->attributes['image'])? asset($this->attributes['image']):null;

    }
}
