<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Slider extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'sliders';
    protected $fillable = [
        'type',
        'name',
        'short_name',
        'url',
        'image',
        'mobile_image',
		'status',
    ];
	protected $appends = ['image_url','mobile_image_url'];
	public function getImageUrlAttribute($value)
    {
        return  !empty($this->attributes['image'])? asset($this->attributes['image']):null;
    }
    public function getMobileImageUrlAttribute($value)
    {
        return  !empty($this->attributes['mobile_image'])? asset($this->attributes['mobile_image']):null;
    }
}