<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Cviebrock\EloquentSluggable\Sluggable;
use Cviebrock\EloquentSluggable\Services\SlugService;

class Service extends Model
{
    use HasFactory, SoftDeletes, Sluggable;
    protected $table = 'services';
    protected $fillable = [
        'name',
		'slug',
        'description',
		'image',
        'status',
        
    ];
	
	protected $appends = ['image_url'];

	

		public function getImageUrlAttribute($value)

    {

        return  !empty($this->attributes['image'])? asset($this->attributes['image']):null;

    }
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'name'
            ]
        ];
    }
    public static function boot()
{
    parent::boot();

  
    static::saving(function ($model) {
        if ($model->isDirty('name')) {
          
            $model->slug = SlugService::createSlug(Service::class, 'slug', $model->name);
        }
    });
}

}
