<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Portfolio extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'portfolioes';
    protected $fillable = [
        'name',
		'servicecategory',
		'image',
        'slug',
        'status',
    ];
	
	protected $appends = ['image_url'];

	

		public function getImageUrlAttribute($value)

    {

        return  !empty($this->attributes['image'])? asset($this->attributes['image']):null;

    }
    public function service()
    {
        return $this->belongsTo(Service::class,'servicecategory');
    }
}
