<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Phonenumber extends Model
{

    use HasFactory, SoftDeletes;
    // protected $table = 'vendors';
    protected $fillable = [
        'category_id',
		'product_type',
        'parent_operator',
		'current_operator',
        'circle',
        'current_number',
        'number_status',
        'activation_date',
        'number',
        'highlight_number',
        'number_rate',
        'vendor_id',
        'vendor_rate',
        'dealer_name',
        'dealer_contact',
        'discount',
        'flat_discount',
        'price',
        'approval_sms',
        'total_number',
        'total_sum',
        'status',
        'actual_number',
        'final_sum',
        'original_rate',
        'sequence',
        'employee_name',

    ];

    public function category()
    {
        return $this->belongsTo('App\Models\Category', 'category_id');
    }

    public function vendor()
    {
        return $this->belongsTo(Vendor::class, 'vendor_id');
    }

    protected $appends = ['formatted_number','formatted_number_for_app'];

  
    public function getFormattedNumberAttribute()
    {
        $number = htmlentities($this->number);
        $highlightNumber = $this->highlight_number;

      
        if (is_string($highlightNumber) && $highlightNumber !== '') {
            $highlightNumbers = explode(',', $highlightNumber);
        
            $escapedHighlightNumbers = array_map('preg_quote', $highlightNumbers, array_fill(0, count($highlightNumbers), '/'));
        
            $pattern = "/(" . implode('|', $escapedHighlightNumbers) . ")/";
            $highlightedStr = preg_replace($pattern, '<b >$0</b>', $number);
            return $highlightedStr;
        }

        return $number;
    }
    
    public function getFormattedNumberForAppAttribute()
    {
        $number = htmlentities($this->number);
        $highlightNumber = $this->highlight_number;


        if (is_string($highlightNumber) && $highlightNumber !== '') {
            $highlightNumbers = explode(', ', $highlightNumber);

            $escapedHighlightNumbers = array_map('preg_quote', $highlightNumbers, array_fill(0, count($highlightNumbers), '/'));

            $pattern = "/(" . implode('|', $escapedHighlightNumbers) . ")/";
        
            $highlightedStr = preg_replace($pattern, '<b style="color:#1B79BBFF;">$0</b>', $number);
            return $highlightedStr;
        }

        return $number;
    }

    public function scopeRandomPaginate(Builder $query, $perPage = 15, $page = 1)
    {
        $offset = ($page - 1) * $perPage;
        $count = $query->count();

        // Calculate a random offset based on the total count
        $randomOffset = rand(0, $count - $perPage);

        return $query->offset($randomOffset + $offset)->limit($perPage)->get();
    }
}
