<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Enquiry extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'enquirys';
    protected $fillable = [
        'first_name',
		'email',
        'mobile',
		'pincode',
        'product_number',
    ];
    public function customer()
    {
        return $this->belongsTo('App\Models\Customer','user_id');
    }

    public function employee()
    {
        return $this->belongsTo('App\Models\Admin','assign_to');
    }

	
}
