<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory; 
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'customers';
    protected $fillable = [
        'name',
        'api_token',
        'first_name',
        'last_name',
        // 'name',
		'slug',
        'mobile',
		'email',
		'state',
		'pincode',
        'city',
        'status',
        'alt_mobile',
        'alt_email',
        'address',
        'password',
        'show_password',
        'customer_type',
        'company_name',
        'gst_number',

    ];

    public function scopeSearch($query, $column, $keyword)
    {
        return $query->where(function ($query) use ($column, $keyword) {
            $query->whereRaw("CONCAT(first_name, ' ', last_name) LIKE ?", ["%{$keyword}%"]);
        });
    }
     
    protected $appends = ['image_url'];

    public function getImageUrlAttribute()
    {
        if ($this->image) {
            return url( $this->image);
        } else {
            return url('uploads/default.png');
        }
    }
	
}
