<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;


class RedirectIfAuthenticatedAdmin
{
   
    public function handle(Request $request, Closure $next, string ...$guards): Response
    {
        if (strpos($request->getPathInfo(), '/admin') === 0) {
            if (!Auth::guard('admin')->check()) {
                session()->put('url.intended', url()->full());
                return redirect()->route('admin.login');
            }
        }
        return $next($request);

    }
}
