<?php

namespace App\Http\Controllers\UserAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\About;
use App\Models\Sitesetting;
use App\Models\Slider;
use App\Models\Education;
use App\Models\Service;
use App\Models\Testimonial;
use App\Models\Media;
use App\Models\Blog;
use App\Models\ClientGallery;
use App\Models\Forecast;


use File;
use Auth;
use DB;
 
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }

    /**
     *
     * @return \Illuminate\Http\Response
     */
   

   
    public function home()
    {
		  $sitesetting = Sitesetting::first();
      $sliders = Slider::where('status', 'Active')->latest('created_at')->get();
      $services = Service::where('status', 'Active')->latest('created_at')->take(3)->get();
      $testimonials = Testimonial::where('status', 'Active')->latest('created_at')->get();
      $media = Media::where('status', 'Active')->latest('created_at')->take(2)->get();
      $blogs = Blog::where('status', 'Active')->latest('created_at')->take(3)->get();
		  $education = Education::first();
		  $forecasts = Forecast::latest('created_at')->get();
      return view('user.home', compact('sitesetting', 'sliders', 'education', 'services', 'testimonials', 'media', 'blogs','forecasts'));
    }

    public function about()
    {
		  $sitesetting = Sitesetting::first();
      $education = Education::first();
      return view('user.aboutus', compact('sitesetting', 'education'));
    }

    public function services()
    {
		  $sitesetting = Sitesetting::first();
      $services = Service::where('status', 'Active')->latest()->get();
      return view('user.services', compact('sitesetting', 'services'));
    }

    public function gallery()
    {
		  $gallery = ClientGallery::where('status', 'Active')->latest()->get();
      return view('user.gallery', compact('gallery'));
    }

    public function contact()
    {
		  $sitesetting = Sitesetting::first();
      return view('user.contact', compact('sitesetting'));
    }

    public function forecastdetails($slug)
    {
        $sitesetting = Sitesetting::first();
        $forecast = Forecast::where('slug', $slug)->firstOrFail();
        return view('user.forecast-details', compact('sitesetting', 'forecast'));
    }
    
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
  
}
