<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\User;
use File;
use Auth;
use DB;
use Hash;

class UserController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    /*public function __construct()
    {
        $this->middleware('auth:admin');
        $this->middleware(function ($request, $next) {
            if(Auth::user()->can(request()->segment(2))){
                return $next($request);
            }
            abort(403);
        });
    }*/
    public function index(Request $request)
    {
        if(!$request->ajax())
            return view('admin.user.index',['title'=>'User list']);
        else
        {
            $limit = 10;
            $serial[] = (request()->input('page')==0)?1:(($limit*(request()->input('page')-1))+1);
            $query = User::where('id','>','0');
            // Search Start
            /* if($request->input('skey')!=''){
                $query = $query->where('name','LIKE','%'.$request->input('skey').'%');
                $query = $query->orWhere('mbl','LIKE','%'.$request->input('skey').'%');
                $query = $query->orWhere('email','LIKE','%'.$request->input('skey').'%');
            } */
           /* if($request->input('sstat')!='')
                $query = $query->where('row_status','=', $request->input('sstat'));

            if($request->input('sdate')!='')
                $query = $query->whereDate('created_at','=', $request->input('sdate'));*/
            /* Search End */
            $count = $query->count();
            $result = $query->orderBy('id','DESC')->paginate($limit);
            return view('admin.user.index',['serial'=>$serial,'count'=>$count,'result'=>$result]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.user.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
         $validator = Validator::make($request->all(), 
                      [ 
                      'name' => 'required',
                      'email' => 'required|email|unique:users',
                      'mbl' => 'required|unique:users',
                     
                      
                     ], [
                    'mbl.required' => 'Mobile Number is Required',
                    'mbl.unique' => 'Mobile Number was all ready registered',
                    'email.email' => 'The email format is wrong – please enter a valid email address',
                ]);  
        if ($validator->fails()) // on validator found any error 
        {
            return redirect(route('admin.user.create'))->withErrors($validator)->withInput();
        }        
        $user = New User();
		$user->name = $request->name;
		$user->mbl = $request->mbl;
		$user->email = $request->email;
		$user->country = $request->country;
		
		$user->password = Hash::make($request->password);
        $user->save();
        return redirect(route('admin.user'))->withSuccess('Added successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
	
		$user = User::Where('id','=',$id)->first();
		/*$user_add = Useraddress::Where('uid','=',$id)->get();*/
		
        return view('admin.user.show',['user'=>$user]);
    }
    public function edit(Request $request)
    {
        $user = User::Where('id','=',$request->id)->first();
        return view('admin.user.form',['user'=>$user]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), 
        [ 
        'name' => 'required',
        'email' => 'required|email|unique:users',
        'mbl' => 'required|unique:users',
       
        
       ], [
      'mbl.required' => 'Mobile Number is Required',
      'mbl.unique' => 'Mobile Number was all ready registered',
      'email.email' => 'The email format is wrong – please enter a valid email address',
       ]); 
        if ($validator->fails()) // on validator found any error 
        {
            return redirect(route('admin.user.form',['id'=>$request->id]))->withErrors($validator)->withInput();
        }
        $user = User::find($request->id);
		$user->brand_id = $request->brand_id;
        $user->save();
        return redirect(route('admin.user'))->withSuccess('Update successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $admin = User::find($request->id);
        User::where('id', '=', $request->id)->delete();
        return redirect(route('admin.user'))->withSuccess('Deleted successfully');
    }
}
