<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Symfony\Component\HttpFoundation\Response;
use App\Models\Testimonial;
use Yajra\Datatables\Datatables;
use File;
use Auth;
use DB;
 
class TestimonialController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }
    private $data = array(
        'route' => 'admin.testimonial.',
        'title' => 'Testimonial',
        'menu' => 'Testimonial',
        'submenu' => '',
    );
    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       
        if ($request->ajax()) {
               
            $records = Testimonial::orderBy('id','DESC');
             $sr = 1;
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('sr_no', function ($record) use (&$sr) {
                    return $sr++;
                })
               
                ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch">
                            <input class="form-check-input status-toggle" style="margin-left:10px;" id="statusToggle" type="checkbox" data-id="' . $record->id . '" data-status="' . $record->status . '" ' . ($record->status == "Active" ? "checked" : "") . '></div>';
                })

                ->editColumn('description', function ($record) {
                    return strip_tags($record->description);
                })

                ->addColumn('image', function ($record) {

					if(!empty($record['image_url'])){

						return '<a href= "'. url($record->image_url).'" target="_blank" ><img src="'.$record->image_url.'" width="100" ></a>';

					}else{

						return '';

					}

				})

                
                ->addColumn('action', function ($record) {
                    return '<a href="'.url('admin/testimonial/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                          '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })
                ->rawColumns(['status','description','action','sr_no','image'])
                ->make(true);
        }
        $this->data['status'] = $request->status;
       
        return view('admin.testimonial.index',$this->data);
    
    }

   
    public function create()
    {
		$testimonial = [];
        return view('admin.testimonial.create')->with(['testimonial'=>$testimonial]);
    }

   
    public function store(Request $request)
    {
		
        $sValidationRules = [
            'name' => 'required',
            'description' => 'required',
            'designation' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        } 
		

		$admin = New Testimonial;
		$admin->name = $request->name;
		$admin->description = $request->description;
		$admin->designation = $request->designation;
		$str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$admin->slug = rtrim($str, '-');
       
       
          if($request->hasFile('image')){
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/testimonial'), $image);
            $admin->image = 'uploads/testimonial/'.$image;
        } 
        
        $admin->save();
		
        return redirect('admin/testimonial')->withSuccess('Added successfully');
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
		$testimonial = Testimonial::find($id);
		
        return view('admin.testimonial.create',['testimonial'=>$testimonial]);
    }

 
    public function update(Request $request,$id)
    {
		$input = $request->all();
		$testimonial = Testimonial::find($id);
	
		 if ($request->ajax()) {
			 
			 if(!empty($request->currentStatus))
		{
	      if($request->currentStatus == 'Active')
          {
			  $testimonial->status = 'Deactive';
		  }	
          else{
			  $testimonial->status = 'Active';
		  }		  
		}
		  $testimonial->save();
          $response['message'] = 'Status Updated Successfully.';
          $response['result'] = '1';
		  return $response;
		
			 
		 }
        $sValidationRules = [
             'name' => 'required',
             'description' => 'required',
             'designation' => 'required',
             'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
       
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
		
		
        
		
      
     
        $str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$input['slug'] = rtrim($str, '-');
      
        
       
      if($request->hasFile('image')){
            if(file_exists(asset($testimonial->image))){
                unlink(asset($testimonial->image));
            }
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/testimonial'), $image);
            $input['image'] = 'uploads/testimonial/'.$image;
        } 
        $testimonial->update($input);
        return redirect('admin/testimonial')->withSuccess('Update successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $admin = Testimonial::find($request->id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        Testimonial::where('id', '=', $request->id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }
	
	
}
