<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\Slider;
use File;
use Auth;
use DB;
use Yajra\Datatables\Datatables;
use Illuminate\Http\Response;
class SliderController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    private $data = array(
        'route' => 'admin.slider.',
        'title' => 'Slider',
        'menu' => 'slider',
        'submenu' => '',
    );
    public function __construct()
    {
      
    }

    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
               
            $records = Slider::select('sliders.*');
             $sr = 1;
            return Datatables::of($records)
                ->addIndexColumn()
                ->editColumn('image', function ($record) {
                    return '<img src="' . $record->image_url . '" style=" height:120px;">';
                })
                ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch" style="left:19px;">
                            <input class="form-check-input status-toggle" id="statusToggle" type="checkbox" data-id="' . $record->id . '" data-status="' . $record->status . '" ' . ($record->status == "Active" ? "checked" : "") . '></div>';
                })
                ->addColumn('action', function ($record) {
                    return '<a href="'.url('admin/slider/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                          '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })
                ->rawColumns(['status','action','image'])
                ->make(true);
        }
          
           
            return view('admin.slider.index',$this->data);
        
    }

   
    public function create()
    {
		$slider = [];
        return view('admin.slider.create')->with(['slider'=>$slider]);
    }

   
    public function store(Request $request)
    {
        $sValidationRules = [
            'image' => 'required_without_all:mobile_image|image|mimes:jpeg,png,jpg,gif,webp',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect('admin/slider/create')->withErrors($validator)->withInput();
        }     
       $admin = New Slider;
       $admin->url = $request->url;
        if($request->hasFile('image')){
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/slider'), $image);
            $admin->image = 'uploads/slider/'.$image;
        }       
        $admin->save();
        return redirect('admin/slider')->withSuccess('Added successfully');
    }

    public function show($id)
    {
		$slider = Slider::find($id);
        return view('admin.slider.show')->with(['slider'=>$slider]);
    }

   
    public function edit($id)
    {
		$slider = Slider::find($id);
		
        return view('admin.slider.create',['slider'=>$slider]);
    }

 
    public function update(Request $request,Slider $slider)
    {
	
		 if ($request->ajax()) {
			 if(!empty($request->currentStatus)){
                if($request->currentStatus == 'Active')
                {
                    $slider->status = 'Deactive';
                }	
                else{
                    $slider->status = 'Active';
                }		  
            }
           
            
		  $slider->save();
          $response['success'] = true;
          $response['message'] = 'Update successfully';
          return response()->json($response);
			 
		 }
        $sValidationRules = [
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);

        // dd($request->all(),$validator);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        
        $slider->url = $request->url;
        if($request->hasFile('image')){
            if(file_exists(asset($slider->image))){
                unlink(asset($slider->image));
            }
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/slider'), $image);
            $slider->image = 'uploads/slider/'.$image;
        } 
       
        $slider->save();
        return redirect('admin/slider')->withSuccess('Update successfully');
    }
  
    public function destroy($id)
    {
        $admin = Slider::find($id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        Slider::where('id', '=', $id)->delete();
        $response['success'] = true;
        $response['message'] = 'Slider Deleted successfully';
        return response()->json($response);
    }
	
}
