<?php



namespace App\Http\Controllers\AdminAuth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


use App\Http\Controllers\Controller;
use App\Models\Sitesetting;
use App\Models\Phonenumber;
use File;
class SitesettingController extends Controller

{
   public function sitesetting()
   {
	   
	   $sitesetting = Sitesetting::first();
	   return view('admin.sitesetting.create')->with(['sitesetting'=>$sitesetting]);
   }   
    public function updatesitesetting(Request $request){
	   $validator = Validator::make($request->all(), [
                    'comp_email' => 'nullable|email',
					'comp_phone' => 'nullable|digits:10',
					'meta_desc' => 'nullable|max:200',
                ], [
                    
                    'comp_email.email' => 'The email format is wrong – please enter a valid email address',
					'email.unique' => 'The email address has already been taken',
					'comp_phone.numeric' => 'Mobile number should be numeric',
                    'comp_phone.digits' => 'Mobile number should have exactly 10 digits',
					'meta_desc.max' => 'Meta description should not exceed 200 characters',
                ]);
				
				if ($validator->fails()) {
                    return redirect()
                            ->back()
                            ->withErrors($validator)
                            ->withInput();
                }
	  
	    $record = Sitesetting::first();
        $admin = $request->all();
       
	
        if($request->hasFile('image')){
            if (file_exists(public_path($record['image']))) {
                unlink(public_path($record['image']));
            }
        
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/sitesetting'), $image);
            $admin['image'] = 'uploads/sitesetting/'.$image;
        
        }
            if($request->hasFile('footer_logo')){
                if (file_exists(public_path($record['footer_logo']))) {
                    unlink(public_path($record['footer_logo']));
                }
                
                $image = rand().time().'.'.$request->footer_logo->extension();
                $request->footer_logo->move(public_path('uploads/sitesetting'), $image);
                $admin['footer_logo'] = 'uploads/sitesetting/'.$image;
                
            }
            if($request->hasFile('fevicon')){
                if (file_exists(public_path($record['fevicon']))) {
                    unlink(public_path($record['fevicon']));
                }
                
                $image = rand().time().'.'.$request->fevicon->extension();
                $request->fevicon->move(public_path('uploads/sitesetting'), $image);
            $admin['fevicon'] = 'uploads/sitesetting/'.$image;
            
            }
            if($request->hasFile('about_img_1')){
                if (file_exists(public_path($record['about_img_1']))) {
                    // unlink(public_path($record['about_img_1']));
                    File::delete(public_path($record['about_img_1']));
                }
                
                $image = rand().time().'.'.$request->about_img_1->extension();
                $request->about_img_1->move(public_path('uploads/sitesetting'), $image);
            $admin['about_img_1'] = 'uploads/sitesetting/'.$image;
            
            }
            if($request->hasFile('about_img_2')){
                if (file_exists(public_path($record['about_img_2']))) {
                    // unlink(public_path($record['about_img_2']));
                    File::delete(public_path($record['about_img_2']));
                }
                
                $image = rand().time().'.'.$request->about_img_2->extension();
                $request->about_img_2->move(public_path('uploads/sitesetting'), $image);
            $admin['about_img_2'] = 'uploads/sitesetting/'.$image;
            
            }
            if($request->hasFile('about_img_3')){
                if (file_exists(public_path($record['about_img_3']))) {
                    // unlink(public_path($record['about_img_3']));
                    File::delete(public_path($record['about_img_3']));
                }
                
                $image = rand().time().'.'.$request->about_img_3->extension();
                $request->about_img_3->move(public_path('uploads/sitesetting'), $image);
            $admin['about_img_3'] = 'uploads/sitesetting/'.$image;
            
            }
            if($request->hasFile('about_img_4')){
                if (file_exists(public_path($record['about_img_4']))) {
                    // unlink(public_path($record['about_img_4']));
                    File::delete(public_path($record['about_img_4']));
                }
                
                $image = rand().time().'.'.$request->about_img_4->extension();
                $request->about_img_4->move(public_path('uploads/sitesetting'), $image);
            $admin['about_img_4'] = 'uploads/sitesetting/'.$image;
            
            }
        
            $record->update($admin);
	 
       
        return redirect()->back()->withSuccess('Update successfully');
    }
    public function getnumber_search(Request $request){
        $record = Sitesetting::first();
        $offerNumberId = $record ? $record->offer_number_id : null;
        $term = trim($request->q);
        if (empty($term)) {
            $tags = Phonenumber::limit(50)->where('status','Available')->get();

            foreach ($tags as $tag) {
                $formatted_tags[] = ['id' => $tag->id, 'text' => $tag->actual_number] ;
            }    
            return response()->json($formatted_tags);
        }


        $tags = Phonenumber::where('actual_number', 'LIKE', $term . '%')->orderByRaw("CASE WHEN actual_number LIKE '$term%' THEN 1 ELSE 2 END")->limit(50)->where('status','Available')->get();

        foreach ($tags as $tag) {
            $formatted_tags[] = ['id' => $tag->id, 'text' => $tag->actual_number,'selected' => $tag->id == $offerNumberId];
        }

        $formatted_tags =!empty($formatted_tags) ?array_values($formatted_tags):[];


        return response()->json($formatted_tags);
    }
   
}
