<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Order;
use App\Models\Customer;
use App\Models\Admin;
use App\Models\Phonenumber;
use App\Models\Orderdetail;
use App\Models\Payment;
use App\Models\VendorAccount;
use App\Models\Sitesetting;
use Yajra\Datatables\Datatables;
use DB;
use Carbon\Carbon;
class SearchOrderController extends Controller
{
    public function __construct()
    {
      
    }

    public function index(Request $request)
    {
            if ($request->ajax()) {
                $orderDetailSearch = $request->search['value'];
                $order_id = $request->order_id;
                $customer_id = $request->customer_id;
                $mobile_no = $request->mobile_no;
                $vanity_number = $request->vanity_number;
                $status = $request->status;
                $startDate = $request->startDate;
                $endDate = $request->endDate;
                $email_id = $request->email_id;
                $order_price = $request->order_price;
                $records = Order::with(['customer', 'orderdetails', 'employee'])
                                    ->when($request->startDate, function ($query) use ($request) {
                                        $startDate = date('Y-m-d 00:00:00', strtotime($request->startDate));
                                        if ($request->endDate) {
                                            $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                                            return $query->whereBetween('order_date', [$startDate, $endDate]);
                                        }
                                        return $query->where('order_date', '>=', $startDate);
                                    })
                                    ->when($request->endDate && !$request->startDate, function ($query) use ($request) {
                                        $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                                        return $query->where('order_date', '<=', $endDate);
                                    });
                                if($order_id){
                                    $records->where('order_number', $order_id); 
                                }
                                if($customer_id){
                                    $records->where('customer_id',$customer_id); 
                                }
                                if($mobile_no){
                                    $records->where('mobile_no',$mobile_no); 
                                }
                                if ($vanity_number) {
                                    $Orderdetail = Orderdetail::where('product_name', $vanity_number)->pluck('order_id');
                                    if ($Orderdetail) {
                                        $records->whereIn('id', $Orderdetail);
                                    } else {
                                        $records->whereRaw('1 = 0');
                                    }
                                }
                                if($status){
                                    $records->where('order_status', $status); 
                                }
                                if($email_id){
                                    $email = Customer::Where('email', 'like', '%' . $email_id . '%')->first();
                                    if($email_id){
                                        $records->where('customer_id', $email->id);
                                    }else{
                                        $records->whereRaw('1 = 0');
                                    }
                                  
                                }
                                if($order_price){
                                    $records->where('order_total', 'like', '%' . $order_price . '%'); 
                                }
                                $records->when($orderDetailSearch, function ($query) use ($orderDetailSearch) {
                                    return $query->Where(function ($q) use ($orderDetailSearch) {
                                                $q->where('mobile_no',$orderDetailSearch)
                                                    ->orWhere('name', 'like', '%' . $orderDetailSearch . '%')
                                                    ->orWhere('order_number',$orderDetailSearch);
                                            });
                                });
                                if($order_id == '' && $customer_id == '' && $mobile_no == '' && $vanity_number == '' && $status == '' && $startDate == '' && $endDate == '' && $email_id == '' && $order_price == ''){
                                    $records->whereRaw('1 = 0');
                                }
                                // ->select('orders.*')
                    $records = $records->orderBy('updated_at', 'DESC');
                 $sr = 1;
                return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('sr_no', function ($record) use (&$sr) {
                        return $sr++;
                    })
                    ->addColumn('purchase_details', function ($record) {
                        // return '<a onclick="window.open(`order/'.$record->id.'/edit`, `_blank`, `height=600, width=800, left=150, top=150,  titlebar=no, toolbar=no, addressbar=no, menubar=no, location=no, resizable=no`);"  href="#">Purchase Detail</a>';
                        return '<a onclick="openPurchasePopup(event, \'order/'.$record->id.'/edit\');" href="#">Purchase Detail</a>';
                    })
                    
                    ->addColumn('customer',function ($record) {
                        // $cus_name = $record->name;
                        // return '<a onclick="window.open(\''.url('admin/customer',$record->customer_id).'\', \'_blank\', \'height=600, width=800, left=150, top=150, titlebar=no, toolbar=no, addressbar=no, menubar=no, location=no, resizable=no\');" href="#">'.$cus_name.'</a>';
                        $cus_name = $record->name;
                        return '<a onclick="openCustomerPopup(event, \''.url('admin/customer', $record->customer_id).'\');" href="#">'.$cus_name.'</a>';
                    })
                    ->addColumn('email', function ($record) {    
                        $cus_name = $record->customer->email??'';
                        return $cus_name;
                    })
                    ->editColumn('created_at', function ($record) {
                        return $record->created_at->format('d-m-Y H:m:s');
                    })

                    ->editColumn('updated_at', function ($record) {
                        return $record->updated_at->format('d-m-Y H:m:s');
                    })

                    ->editColumn('order_total', function ($record) {
                        return round($record->order_total,2);
                    })

                    ->editColumn('order_status', function ($record) {
                        $order_status = str_replace('_', ' ', $record->order_status);
                        $order_status = ucfirst($order_status);
                        return $order_status;
                    })
                    ->addColumn('action', function ($record) {
                     
                        $button = '<button class="btn btn-sm btn-primary data-edit" onclick="window.open(`orderactivity/'.$record->id.'`, `_blank`, `height=500, width=800, left=150, top=150,  titlebar=no, toolbar=no, addressbar=no, menubar=no, location=no, resizable=no`);" data-id="'.$record->id.'" title=""><i class="fe fe-edit"></i></button>';

                            $invoiceIcon = '';
                            if ($record->payment_status == 'Paid') {
                                $invoiceIcon = '<a href="'.url('admin/orderinvoice', $record->id).'" style="margin-left: 7px;"><i class="fas fa-file"></i></a>';
                            }

                            $paymentFormIcon = '<a href="'.url('admin/paymentForm', $record->id).'" class=""><i class="fa fa-credit-card"></i></a>';
                            return $button . ' ' . $invoiceIcon . ' <br>' . $paymentFormIcon;
                      
                    })
                   
                    ->rawColumns(['status','action','customer','sr_no','purchase_details','email']) 
                    ->make(true);
            }
            return view('admin.searchOrder.index');
        
    }

    
}
