<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Vendor;
use App\Models\Commission;
use App\Models\Phonenumber;
use App\Models\Category;
use App\Models\BulkFileDetail;
use App\Models\VendorAccount;
use App\Models\Admin;
use File;
use Auth;
use DB;
use Symfony\Component\HttpFoundation\Response;
use Yajra\Datatables\Datatables;
class PhonenumberController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }
    private $data = array(
        'route' => 'admin.phone.',
        'title' => 'Number',
        'menu' => 'Number',
        'submenu' => '',
    );

    public function index(Request $request)
    {
       
            if ($request->ajax()) {
                //    print_r($request->status);exit;
                $records = Phonenumber::with('category','vendor')->select('phonenumbers.*');
                            if(!empty($request->status != "All")){
                                $records->where('status',$request->status);
                            }
                            
                            // if(!empty($request->search)){
                            //     $records->where('actual_number',$request->search);
                            // }
                            
                $records = $records->orderBy('id','DESC');
                // print_r($records);exit;
                 $sr = 1;
                return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('sr_no', function ($record) use (&$sr) {
                        return $sr++;
                    })
                    ->editColumn('sequence', function ($record){
                        return '<input style="width: 50px;color:black;" type="text" class="mainfrrom form-control txt_inline_edit sequence_update inline_update" name="" value="'.$record['sequence'].'" row_id="'.$record['id'].'" field="sequence" />';
                    })
                    ->editColumn('updated_at', function ($record) {
                        return $record->updated_at->format('d-m-Y H:i:s').' by '.$record->employee_name??'';
                    })
                    ->editColumn('status', function ($record) {
                        return '<span style="color:#0162e8;">'.$record->status.'</span>';
                    })
                    ->editColumn('status', function ($record) {
                        return '<select name="orderstatus" class="change_numberstatus form-select js-example-basic-multiple" data-id="' . $record->id . '">
                                    <option value="Available" ' . ($record->status == "Available" ? " selected" : "") . '>Available</option>
                                    <option value="Sold" ' . ($record->status == "Sold" ? " selected" : "") . '>Sold</option>' .
                                    ($record->status != "Sold" ? '<option value="sold_by_vendor" ' . ($record->status == "sold_by_vendor" ? " selected" : "") . '>Sold By Vendor</option>' : '') . '
                                    <option value="Hold" ' . ($record->status == "Hold" ? " selected" : "") . '>Hold</option>
                                    <option value="not_available" ' . ($record->status == "not_available" ? " selected" : "") . '>Not Available</option>
                                    <option value="vendor_deactivated" ' . ($record->status == "vendor_deactivated" ? " selected" : "") . '>Vendor Deactivated</option>
                                </select>';
                    })
                    ->addColumn('action', function ($record) {
                        return '<a href="'.url('admin/phone/'.$record->id) .'" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="" data-bs-original-title="view"><i class="fe fe-eye"></i></a> '.
                              '&nbsp;<a href="'.url('admin/phone/'.$record->id.'/edit?previous=phone').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                              '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                    })
                    ->rawColumns(['status','action','sr_no','sequence'])
                    ->make(true);
            }
            $this->data['status'] = $request->status;
           
            return view('admin.phonenumber.index',$this->data);
        
    }

    public function indexsearch(Request $request)
    {
       
            if ($request->ajax()) {
               $search = str_replace(" ","",$request->search);
                $records = Phonenumber::with('category','vendor')->select('phonenumbers.*');
                            // if(!empty($request->status)){
                            //     $records->where('status',$request->status);
                            // }
                            // if(!empty($request->search)){
                                $records->where('actual_number',$search);
                            // }
                            
                $records = $records->orderBy('id','DESC');
                 $sr = 1;
                return Datatables::of($records)
                    ->addIndexColumn()
                    ->addColumn('sr_no', function ($record) use (&$sr) {
                        return $sr++;
                    })
                    ->editColumn('updated_at', function ($record) {
                        return $record->updated_at->format('d-m-Y H:i:s').' by '.$record->employee_name??'';
                    })
                    ->editColumn('status', function ($record) {
                        return '<span style="color:#0162e8;">'.$record->status.'</span>';
                    })
                    ->editColumn('status', function ($record) {
                        return '<select name="orderstatus" class="change_numberstatus form-select js-example-basic-multiple" data-id="' . $record->id . '">
                                    <option value="Available" '.($record->status == "Available" ? " selected" : "").'>Available</option>
                                    <option value="Sold" '.($record->status == "Sold" ? " selected" : "").'>Sold</option>
                                    <option value="sold_by_vendor" '.($record->status == "sold_by_vendor" ? " selected" : "").'>Sold By Vendor</option>
                                    <option value="Hold" '.($record->status == "Hold" ? " selected" : "").'>Hold</option>
                                    <option value="not_available" '.($record->status == "not_available" ? " selected" : "").'>Not Available</option>
                                    <option value="vendor_deactivated" '.($record->status == "vendor_deactivated" ? " selected" : "").'>Vendor Deactivated</option>
                                </select>
                                ';
                    })
                    ->addColumn('action', function ($record) {
                        return '<a href="'.url('admin/phone/'.$record->id) .'" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="" data-bs-original-title="view"><i class="fe fe-eye"></i></a> '.
                              '&nbsp;<a href="'.url('admin/phone/'.$record->id.'/edit?previous=phonesearch').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                              '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                    })
                    ->rawColumns(['status','action','sr_no'])
                    ->make(true);
            }
            $this->data['status'] = $request->status;
           
            return view('admin.phonenumber.indexsearch',$this->data);
        
    }
   
    public function create()
    {
		$numbers = null;
        $categories = Category::get();
        $vendors = Vendor::get();
        return view('admin.phonenumber.create')->with(['numbers'=>$numbers,'categories'=>$categories,'vendors'=>$vendors]);
    }

   
    public function store(Request $request)
    {
		
        $sValidationRules = [
            'category_id' => 'required',
			'vendor_id' => 'required',
            // 'number' => 'required|digits:10',
            // 'highlight_number' => 'required',
        ];
		
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }  
		
        $input = $request->all();
        $numberWithoutSpaces = str_replace(' ', '', $request->number);
        $numberOfDigits = strlen($numberWithoutSpaces);
        if ($numberOfDigits != 10) {
            return redirect()->back()->withErrors(['number' => 'The number must be 10 digits.'])->withInput($request->only('number'));
        }

        $numbersArray = str_split($numberWithoutSpaces);
        $totalNumber = array_sum($numbersArray);
        $input['total_number'] = $totalNumber;

        $numbersArray = str_split($totalNumber);
        $total_sum = array_sum($numbersArray);
        $input['total_sum'] = $total_sum;

        $numbersArray = str_split($total_sum);
        $final_sum = array_sum($numbersArray);
        $input['final_sum'] = $final_sum;
        
        $input['actual_number'] = $numberWithoutSpaces;
        $input['original_rate'] = $request->number_rate;
        $comission = Commission::where('from_amount','<=',$request->vendor_rate)->where('to_amount','>=',$request->vendor_rate)->first();
                    if($comission){
                        if($comission->commission == null || $comission->commission == 0 )
                        {
                            $input['number_rate'] = ceil($comission->commission_flat + $request->vendor_rate) ;
                        }else{
                            $c = ($request->vendor_rate * $comission->commission)/100;
                            $input['number_rate'] = ceil($c + $request->vendor_rate);
                        }
                    }else{

                        $input['number_rate'] = ceil($request->vendor_rate);
                    }
        $input['employee_name'] = auth()->user()->name??'';
        $numbers = Phonenumber::withTrashed()->where('actual_number',$numberWithoutSpaces)->where('status','!=','Sold')->first();
        if(empty($numbers)){
            $admin = New Phonenumber($input);
            $admin->save();
            return redirect('admin/phone?status=Available')->withSuccess('Added successfully');
        }else{
            if ($numbers->trashed() && $numbers->status != 'Sold') {
                $numbers->restore();
            }
            $numbers->update($input);
            return redirect('admin/phone?status=Available')->withSuccess('This number already exists.Update successfully');
        }
       
        
		
       
    }

    public function show($id)
    {
		$number = Phonenumber::find($id);
        return view('admin.phonenumber.show')->with(['number'=>$number]);
    }

 
    public function edit($id)
    {
        
		$numbers = Phonenumber::find($id);
        // print_r($numbers->number);exit;
        $categories = Category::get();
        $vendors = Vendor::get();
        return view('admin.phonenumber.create',['numbers'=>$numbers,'categories'=>$categories,'vendors'=>$vendors]);
    }

 
    public function update(Request $request,$id)
    {

        if ($request->ajax()) {
            $number = Phonenumber::find($request->id);
            // if($number->status == 'Sold'){
            //     $response['success'] = false;
            //     $response['message'] = 'This number is already sold.';
            //     return response()->json($response);
            // }
            $number->status = $request->status;
            $number->save();

            $response['success'] = true;
            $response['message'] = 'Update successfully';
            return response()->json($response);
        }

		$input = $request->all();
		$phonenumber = Phonenumber::find($id);


        if($phonenumber->status == 'Sold'){

            session()->flash('error', 'This number is already sold.');
            return redirect()->back();

        }
       
         $sValidationRules = [
            'category_id' => 'required',
			'vendor_id' => 'required',
            // 'number' => 'required|digits:10',
            // 'highlight_number' => 'required',
        ];
		
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }  
        
        $numberWithoutSpaces = str_replace(' ', '', $request->number);
        $numberOfDigits = strlen($numberWithoutSpaces);
        if ($numberOfDigits != 10) {
            return redirect()->back()->withErrors(['number' => 'The number must be 10 digits.'])->withInput($request->only('number'));
        }
        $numbersArray = str_split($numberWithoutSpaces);
        $totalNumber = array_sum($numbersArray);
        $input['total_number'] = $totalNumber;

        $numbersArray = str_split($totalNumber);
        $total_sum = array_sum($numbersArray);
        $input['total_sum'] = $total_sum;

        $numbersArray = str_split($total_sum);
        $final_sum = array_sum($numbersArray);
        $input['final_sum'] = $final_sum;

        $input['actual_number'] = $numberWithoutSpaces;
        $input['number_rate'] = $request->number_rate;
        // dd($request->number_rate);
        /*$comission = Commission::where('from_amount','<=',$request->vendor_rate)->where('to_amount','>=',$request->vendor_rate)->first();
                    if($comission)
                    {
                        if($comission->commission == null || $comission->commission == 0 )
                        {
                            $input['number_rate'] = ceil($comission->commission_flat + $request->vendor_rate) ;
                        }else{
                            $c = ($request->vendor_rate * $comission->commission)/100;
                            $input['number_rate'] = ceil($c + $request->vendor_rate);
                        }
                    }
                    else{

                        $input['number_rate'] = ceil($request->vendor_rate);
                    }*/
        $input['employee_name'] = auth()->user()->name??'';
        $phonenumber->update($input);
        $vaccount = VendorAccount::where('product_id',$id)->first();
        if($vaccount){
            if($vaccount->vendor_id != $request->vendor_id){
                $vaccount->vendor_id = $request->vendor_id;
                $vaccount->update();
            }
        }
        return redirect('admin/'.$request->previous.'?status='.$phonenumber->status)->withSuccess('Update successfully');
        // return redirect()->back()->withSuccess('Update successfully');
    }

  
    public function destroy($id)
    {
        

        $number = Phonenumber::where('id', '=', $id)->first();
        if($number->status == 'Sold'){
            $response['success'] = false;
            $response['message'] = 'This number is already sold.';
            return response()->json($response);
        }
        $number->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }

   public function vendorproduct(Request $request)
   {
    if ($request->ajax()) {
       
        if(!empty($request->vendor_id))
        {
       
          $records = Phonenumber::with('category','vendor')->select('phonenumbers.*')->where('phonenumbers.vendor_id',$request->vendor_id)->orderBy('id','DESC');
        }
        else{
            $records= [];
        }
         $sr = 1;
        return Datatables::of($records)
            ->addIndexColumn()
            ->addColumn('sr_no', function ($record) use (&$sr) {
                return $sr++;
            })
            ->editColumn('updated_at', function ($record) {
                return $record->updated_at->format('d-m-Y H:m:s');
            })
            ->editColumn('status', function ($record) {
                return '<span style="color:#0162e8;">'.$record->status.'</span>';
            })
            ->addColumn('action', function ($record) {
                return '<a href="'.url('admin/phone/'.$record->id) .'" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="" data-bs-original-title="view"><i class="fe fe-eye"></i></a> '.
                      '&nbsp;<a href="'.url('admin/phone/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                      '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
            })
            ->rawColumns(['status','action','sr_no'])
            ->make(true);
    }
    $this->data['status'] = $request->status;
    $this->data['vendor'] = Vendor::get();
    return view('admin.phonenumber.vendorproduct',$this->data);

   }

   public function sequenceupdate(Request $request){
    $record = Phonenumber::where('id',$request->id)->first();
    
    if ($request->ajax()) {
        $record->sequence = $request->sequence;
        $record->update();
        return response()->json(['result' => 'success']);
    }
}
}
