<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Crypt;
use App\Models\Vendor;
use App\Models\Payment;
use App\Models\User;
use Symfony\Component\HttpFoundation\Response;
use Yajra\Datatables\Datatables;
use File;
use Auth;
use DB;
 
class PaymentController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }
    private $data = array(
        'route' => 'admin.payment.',
        'title' => 'Payment',
        'menu' => 'Payment',
        'submenu' => '',
    );


    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
              

            $query = Payment::with(['customer'])->orderBy('payments.id', 'DESC');

            // Filter by order number if provided
            if ($request->customer_id) {
                $query->where('customer_id',$request->customer_id);
            }
            
            $records = $query->select('payments.*');
        
           
             $sr = 1;   
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('sr_no', function ($record) use (&$sr) {
                    return $sr++;
                })
                ->addColumn('customer_number', function ($record) {
                    $first_name = $record->customer->first_name??"";
                    $last_name = $record->customer->last_name??"";
                    $name = $first_name??"".' '.$last_name??"";
                    return $name??"";
                })
                ->addColumn('mobile_number', function ($record) {
                    return $record->customer->mobile??"";
                })
                ->editColumn('remarks',function($record){
                    return strip_tags($record->remarks);
                })
                ->editColumn('created_at',function($record){
                    return date('d-m-Y',strtotime($record->created_at));
                })
                ->addColumn('image',function($record){
                    if (!empty($record->image)) {
                        return '<a href="' . $record->image_url . '" target="_blank">View</a>';
                    } else {
                        return '';
                    }
                })
                ->addColumn('action', function ($record) {
                    return '<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })
                ->rawColumns(['action','sr_no','mobile_number','customer_number','image'])
                ->make(true);
        }
       
       
        return view('admin.payment.index',$this->data);
    
    }
    
    public function show($id)
    {
		$vendor = Vendor::find($id);
        return view('admin.vendor.show')->with(['vendor'=>$vendor]);
    }
   
    public function destroy(Request $request)
    {
        $admin = Payment::find($request->id);
         
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 

        Payment::where('id', '=', $admin->id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }
	
	
}
