<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\Customer;
use App\Models\Enquiry;
use App\Models\OrderActivity;
use App\Models\Orderdetail;
use App\Models\VendorAccount;

class OrderActivityController extends Controller
{

    public function orderactivity($id)
    {
        $order = Order::find($id);
        $order_activity = OrderActivity::where('order_id',$id)->get();
        $last_order_activity = OrderActivity::where('order_id',$id)->orderBy('id','DESC')->first();
        
        $customer = Customer::find($order->customer_id);
        $order_id = Order::where('customer_id',$customer->id)->pluck('id');
        $enquiries = Enquiry::where('mobile',$order->mobile_no)->get();
        return view('admin.orderactivity.show',['order'=>$order,'customer'=>$customer,'order_activity'=>$order_activity,'enquiries'=>$enquiries,'last_order_activity'=>$last_order_activity,'order_id'=>$order_id]);
    }

    public function activityupdate(Request $request)
    {
       
      $input['employee_id'] = $request->employee_id;
      $input['status'] =$request->status;
      $input['remark'] = $request->remark??null;
      $input['order_id'] = $request->order_id;
      $activity = new OrderActivity($input);
      $activity->save();
     
      $order = Order::find($request->order_id);
      $order->order_status = $request->status;
      $order->assign_to =$request->employee_id;
      $order->update();

      if($request->status == 'to_be_refund' || $request->status == 'refund' || $request->status == 'cancelled'){
        $order_detail = Orderdetail::where('order_id', $request->order_id)->get();  
          foreach($order_detail as $order_detail){
              $vendoraccount_status_update = VendorAccount::where('vendor_id',$order_detail->vendor_id)
                                                          ->where('order_id',$order_detail->order_id)
                                                          ->where('product_id',$order_detail->product_id)
                                                          ->where('payment_elegible','N')
                                                          ->first();
              if(!empty($vendoraccount_status_update)){
                $vendoraccount_status_update->payment_elegible = 'C';
                $vendoraccount_status_update->payment_status = 'C';
                $vendoraccount_status_update->update();
              }

          }
       
    }
       

  

      return redirect()->back()->with('success','Order activity update successfully');
    }

}