<?php

namespace App\Http\Controllers\AdminAuth;

use App\Models\Admin;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class LoginRegisterController extends Controller
{
   
    public function __construct()
    {
        // $this->middleware('guest:admin')->except([
        //     'logout', 'dashboard'
        // ]);
    }
    public function login()
    {
        return view('admin.login');
    }
    public function authenticate(Request $request)
    {
        $credentials = $request->validate([
            'email' => 'required|email',
            'password' => 'required|min:6'
        ]);

        if(Auth::guard('admin')->attempt($credentials))
        {
           
            $request->session()->regenerate();
            // return redirect()->route('admin.dashboard')->withSuccess('You have successfully logged in!');
            return redirect()->intended(route('admin.dashboard'))->withSuccess('You have successfully logged in!');
              
        }

        return back()->withErrors([
            'email' => 'Your provided credentials do not match in our records.',
        ])->onlyInput('email');

    } 
   
    public function logout(Request $request)
    {
        Auth::guard('admin')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('admin.login')->withSuccess('You have logged out successfully!');;
    }    

}