<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Forecast;
use Symfony\Component\HttpFoundation\Response;
use Yajra\Datatables\Datatables;
use File;
use Auth;
use DB;

class ForecastController extends Controller
{

    public function __construct()
    {
    
    }

    private $data = array(
        'route' => 'admin.forecast.',
        'title' => 'Forecast',
        'menu' => 'Forecast',
        'submenu' => '',
    );

    public function index(Request $request)
    {
        if ($request->ajax()) {
            $records = Forecast::select('*');

            return Datatables::of($records)
                ->addIndexColumn()

                ->editColumn('image', function ($record) {
                    $basePath = asset('assets/admin/');
                    $src = $record->image ? $basePath . '/' . ltrim($record->image, '/') : asset('assets/user/images/not-availbale.png');
                        
                
                    return '<a href="' . $src . '" target="_blank">
                                <img src="' . $src . '" style="height:80px; border-radius:4px;">
                            </a>';
                })
                

                ->editColumn('datee', function ($record) {
                    return $record->start_date . ' – ' . $record->end_date;
                })

                ->editColumn('created_at', function ($record) {
                    return $record->created_at?->format('d M Y, h:i A') ?? '—';
                })

                ->addColumn('action', function ($record) {
                    return '<a href="' . url('admin/forecast/' . $record->id . '/edit') . '" 
                                class="btn btn-sm btn-info btn-b" 
                                data-bs-toggle="tooltip" title="Edit">
                                <i class="fe fe-edit"></i>
                            </a>';
                })

                ->rawColumns(['action', 'image'])

                ->filter(function ($query) use ($request) {
                    if ($search = $request->get('search')['value']) {
                        $search = '%' . strtolower($search) . '%';
                        
                        $query->where(function ($q) use ($search) {
                            $q->whereRaw('LOWER(title) LIKE ?', [$search])
                              ->orWhereRaw('LOWER(description) LIKE ?', [$search])
                              ->orWhereRaw('LOWER(CONVERT(start_date USING utf8mb4)) LIKE ?', [$search])
                              ->orWhereRaw('LOWER(CONVERT(end_date USING utf8mb4)) LIKE ?', [$search]);
                        });
                    }
                })

                ->make(true);
        }

        return view('admin.forecast.index', $this->data);
    }

    public function create()
    {
        return view('admin.forecast.create', ['record' => null]);
    }

    public function edit($id)
    {
        $record = Forecast::findOrFail($id);
        return view('admin.forecast.create', compact('record'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'forecast_date' => 'nullable|date',
        ]);
        Forecast::create($request->all());
        return redirect('admin/forecast');
    }

    public function update(Request $request, $id)
    {
        $record = Forecast::findOrFail($id);

        $request->validate([
            'title'       => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);

        $record->title       = $request->title;
        $record->description = $request->description;
        $record->start_date  = $request->start_date;
        $record->end_date    = $request->end_date;

        $record->save();

        return view('admin.forecast.create', compact('record'));
    }
}