<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Phonenumber;
use App\Models\Category;
use App\Models\Vendor;
use App\Models\Order;
use App\Models\Orderdetail;
use App\Models\Enquiry;
use App\Models\Customer;
use App\Models\Payment;
use App\Models\Wishlist;
use File;
use Auth;
use DB;
use Symfony\Component\HttpFoundation\Response;
use Yajra\Datatables\Datatables;
class ExportController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }

    public function numberexport()
    {
        $categories = Category::get();
        $vendors = Vendor::get();
        $record['vendors'] = $vendors;
        $record['categories'] = $categories;
        return view('admin.export.numberExport',$record);
    }


    public function exportnumber(Request $request){
        $categoryId = $request->category_id;
        $num_export = Phonenumber::select('phonenumbers.*')->with('category','vendor');
                    if (!empty($categoryId) && $categoryId == 'without_2_4_8') {
                        $num_export->where('actual_number', 'not like', '%' . 2 . '%')
                                    ->where('actual_number', 'not like', '%' . 4 . '%')
                                    ->where('actual_number', 'not like', '%' . 8 . '%');
                    } elseif (!empty($categoryId)) {
                        $num_export->where('category_id',$categoryId);
                    }
                    if(!empty($request->product_type)){
                        $num_export->where('product_type',$request->product_type);
                    }
                    if(!empty($request->number_status)){
                        $num_export->where('number_status',$request->number_status);
                    }

                    if(!empty($request->vendor_id)){
                        $num_export->where('vendor_id',$request->vendor_id);
                    }

                    if(!empty($request->status) && $request->status != 'ALL'){
                        $num_export->where('status',$request->status);
                    }
        $num_export = $num_export->get();
        // dd($num_export);
        $errorCsvFileName = 'Numbers.csv';
        $errorCsvFile = fopen($errorCsvFileName, 'w');
        fputcsv($errorCsvFile, ['SR	', 'Category id', 'Vendor ID', 'Category Name', 'Vanity Number','Highlight Number', 'Parent Operator', 'Current Operator', 'Circle', 'Number Status','Activation Date', 'Dealer Name', 'Dealer Contact', 'Rate In Ruppes', 'Vendor Rate', 'Discount', 'Status', 'Sum Total', 'Vendor Name', 'Updated Date', 'sequence']);
        foreach ($num_export as $key => $value) {
            $row = [$key+1, $value->category_id, $value->vendor_id, $value->category->name??'', $value->number,$value->highlight_number, $value->parent_operator, $value->current_operator, $value->circle, $value->number_status,$value->activation_date, $value->dealer_name, $value->dealer_contact, $value->original_rate, $value->vendor_rate, $value->discount, $value->status, $value->total_number, $value->vendor->name??'', date('d-m-Y',strtotime($value->updated_at)), $value->sequence];
            fputcsv($errorCsvFile, $row);
        }
        fclose($errorCsvFile);
        return response()->download($errorCsvFileName)->deleteFileAfterSend(true);
    }

    public function orderExpert(Request $request){
        return view('admin.export.orderExpert');
    }

    /* public function order_expert(Request $request){
        // dd($request->all());
        $order_id = $request->order_id;
        $customer_id = $request->customer_id;
        $mobile_no = $request->mobile_no;
        $vanity_number = $request->vanity_number;
        $status = $request->status;
        $startDate = $request->startDate;
        $endDate = $request->endDate;
        $records = Order::with([ 'employee'])->select('id', 'order_number', 'name', 'mobile_no', 'order_date', 'order_status', 'order_total','assign_to');
                    if($startDate){
                        $startDate = date('Y-m-d 00:00:00', strtotime($startDate) );
                        $records->where('order_date', '>=', $startDate);
                    }
                    if($endDate){
                        $endDate = date('Y-m-d 23:59:59', strtotime($endDate));
                        $records->where('order_date', '<=', $endDate);
                    }
                    //    ->when($request->startDate, function ($query) use ($request) {
                    //         $startDate = date('Y-m-d 00:00:00', strtotime($request->startDate));
                    //         if ($request->endDate) {
                    //             $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                    //             return $query->whereBetween('order_date', [$startDate, $endDate]);
                    //         }
                    //         return $query->where('order_date', '>=', $startDate);
                    //     })
                    //     ->when($request->endDate && !$request->startDate, function ($query) use ($request) {
                    //         $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                    //         return $query->where('order_date', '<=', $endDate);
                    //     });
                    if($order_id){
                        $records->where('order_number', $order_id); 
                    }
                    if($customer_id){
                        $records->where('customer_id',$customer_id); 
                    }
                    if($mobile_no){
                        $records->where('mobile_no',$mobile_no); 
                    }
                    if ($vanity_number) {
                        $Orderdetail = Orderdetail::where('product_name', $vanity_number)->first();
                        if ($Orderdetail) {
                            $records->where('id', $Orderdetail->order_id);
                        } else {
                            $records->whereRaw('1 = 0');
                        }
                    }
                    if($status != 'All'){
                        $records->where('order_status', $status); 
                    }
        $records = $records->orderBy('updated_at', 'DESC')->get();


        $errorCsvFileName = 'orderExpert.csv';
        $errorCsvFile = fopen($errorCsvFileName, 'w');
        fputcsv($errorCsvFile, ['SR	','Order Id', 'Customer Name', 'Mobile No', 'Vanity Number', 'Order Date', 'Order Status', 'Total Amount', 'Employee Name']);
            foreach ($records as $key => $value) {
                $Orderdetail = Orderdetail::where('order_id', $value->id)->pluck('product_name')->toArray();
                $product_name = $Orderdetail?implode(', ', $Orderdetail):'';        
                $row = [$key+1, $value->order_number, $value->name, $value->mobile_no, $product_name??'', date('d-m-Y', strtotime($value->order_date)), $value->order_status, $value->order_total, $value->employee->name??''];
                fputcsv($errorCsvFile, $row);
            }
        
        fclose($errorCsvFile);
        return response()->download($errorCsvFileName)->deleteFileAfterSend(true);
    }*/
    public function order_expert(Request $request){
        // dd($request->all());
        $order_id = $request->order_id;
        $customer_id = $request->customer_id;
        $mobile_no = $request->mobile_no;
        $vanity_number = $request->vanity_number;
        $status = $request->status;
        $startDate = $request->startDate;
        $endDate = $request->endDate;
        $records = Order::with([ 'employee'])->select('id', 'order_number', 'name', 'mobile_no', 'order_date', 'order_status', 'order_total','assign_to')
                    ->when($request->startDate, function ($query) use ($request) {
                        $startDate = date('Y-m-d 00:00:00', strtotime($request->startDate));
                        if ($request->endDate) {
                            $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                            return $query->whereBetween('orders.order_date', [$startDate, $endDate]);
                        }
                        return $query->where('orders.order_date', '>=', $startDate);
                    })
                    ->when($request->endDate && !$request->startDate, function ($query) use ($request) {
                        $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                        return $query->where('orders.order_date', '<=', $endDate);
                    });
                    if($order_id){
                        $records->where('order_number', $order_id); 
                    }
                    if($customer_id){
                        $records->where('customer_id',$customer_id); 
                    }
                    if($mobile_no){
                        $records->where('mobile_no',$mobile_no); 
                    }
                    if ($vanity_number) {
                        $Orderdetail = Orderdetail::where('product_name', $vanity_number)->first();
                        if ($Orderdetail) {
                            $records->where('id', $Orderdetail->order_id);
                        } else {
                            $records->whereRaw('1 = 0');
                        }
                    }
                    if($status != 'All'){
                        $records->where('order_status', $status); 
                    }
        $records = $records->orderBy('updated_at', 'DESC')->get();
        $data = [
            'records' => $records,
        ];
        return response()->json([
            'success' => true,
            'html' => view('admin.export.orderexcel', $data)->render()
        ]);
        // return response()->download($errorCsvFileName)->deleteFileAfterSend(true);
    }
    
    public function enquiryExpert(Request $request){
        return view('admin.export.enquiryExport');
    }

    public function expertEnquiry(Request $request){
        $start_date = $request->startDate;
        $end_date = $request->endDate;
        $status = $request->status;
        $customer_id = $request->customer_id;
        $mobile_no = $request->mobile_no;
        $vanity_number = $request->vanity_number;
        $query = Enquiry::orderBy('enquirys.id', 'DESC')->with(['employee']);
            if($status && $status != 'ALL'){
                $query->where('enquirys.status',$status);
            }
            if($customer_id){
                $query->where('enquirys.user_id',$customer_id);
            }
            if($mobile_no){
                $query->where('enquirys.mobile',$mobile_no);
            }
            if($vanity_number){
                $query->where('enquirys.product_number',$vanity_number);
            }
            if($vanity_number){
                $query->where('enquirys.product_number',$vanity_number);
            }
            if (!empty($start_date)) {
                if (!empty($end_date)) {
                    $query->where('enquirys.created_at', '>=', date('Y-m-d 00:00:00',strtotime($start_date)));
                } else {
                    $query->where('enquirys.created_at', '=',  date('Y-m-d 00:00:00',strtotime($start_date)));
                }
            }
            if (!empty($end_date)) {
                $query->where('enquirys.created_at', '<=',  date('Y-m-d 23:59:59',strtotime($end_date)));
            }
            $records = $query->get();

            $errorCsvFileName = 'enquiryExpert.csv';
            $errorCsvFile = fopen($errorCsvFileName, 'w');
            fputcsv($errorCsvFile, ['SR	','Customer Name','Vanity Number','Email','Mobile No','Assign To','Enquiry Date','Status']);
            foreach ($records as $key => $value) {
                $row = [$key+1, $value->first_name, $value->product_number, $value->email, $value->mobile,$value->employee->name??'', date('d-m-Y H:i:s', strtotime($value->created_at)), $value->status];
                fputcsv($errorCsvFile, $row);
            }
            fclose($errorCsvFile);
            return response()->download($errorCsvFileName)->deleteFileAfterSend(true);
    }

    public function customerExpert(Request $request){
        return view('admin.export.customerExpert');
    }

    public function expertCustomer(Request $request) {
        $start_date = $request->startDate;
        $end_date = $request->endDate;
        $status = $request->status;
        $customer_id = $request->customer_id;
        $state = $request->state;

        
        $query = Customer::orderBy('id','DESC');
            if (!empty($start_date)) {
                if (!empty($end_date)) {
                    $query->where('created_at', '>=', date('Y-m-d 00:00:00',strtotime($start_date)));
                } else {
                    $query->where('created_at', '=',  date('Y-m-d 00:00:00',strtotime($start_date)));
                }
            }
            if (!empty($end_date)) {
                $query->where('created_at', '<=',  date('Y-m-d 23:59:59',strtotime($end_date)));
            }
            if($status && $status != 'ALL'){
                $query->where('status',$status);
            }
            if($customer_id){
                $query->where('id',$customer_id);
            }
            if($state){
                $query->where('state',$state);
            }
            if($state){
                $query->where('state',$state);
            }
            $records = $query->get();

            $errorCsvFileName = 'expertCustomer.csv';

            $errorCsvFile = fopen($errorCsvFileName, 'w');
            fputcsv($errorCsvFile, ['SR	','Name','Contact Number','Alt Contact Number','Email','Alt Email Address','Customer Type','Address','Pincode','State','Status','Company Name','Gst']);
            foreach ($records as $key => $value) {
                $row = [$key+1, $value->first_name.' '.$value->last_name, $value->mobile, $value->alt_mobile, $value->email,$value->alt_email,$value->customer_type,$value->address,$value->pincode, $value->state,$value->status,$value->company_name,$value->gst_number];
                fputcsv($errorCsvFile, $row);

            }
            fclose($errorCsvFile);
            return response()->download($errorCsvFileName)->deleteFileAfterSend(true);
                        
    }
    public function gstExpert(Request $request){
        return view('admin.export.gstExpert');
    }
    public function gst_expert(Request $request) {
        $start_date = $request->start_date;
        $end_date = $request->end_date;
        $query = Payment::orderBy('payments.id','DESC')->leftjoin('orders','orders.id','payments.order_id')->where('orders.gst_status','!=','No');
            if (!empty($start_date)) {
                if (!empty($end_date)) {
                    $query->whereDate('payments.created_at', '>=', date('Y-m-d',strtotime($start_date)));
                } else {
                    $query->whereDate('payments.created_at', '=',  date('Y-m-d',strtotime($start_date)));
                }
            }
            if (!empty($end_date)) {
                $query->whereDate('payments.created_at', '<=',  date('Y-m-d',strtotime($end_date)));
            }
            $records = $query->get();

            $errorCsvFileName = 'Gstexport.csv';
            $errorCsvFile = fopen($errorCsvFileName, 'w');
            fputcsv($errorCsvFile, ['SR	','Order Id','Name','Contact Number','Email','State','Invoice No','Customer Type','Company Name','Gst Number','Amount','Gst Amount','Payment Mode','Transaction Id','UTR','Payment date']);
            foreach ($records as $key => $value) {
                $row = [
                    $key + 1,
                    $value->order_number ?? '',
                    optional($value->customer)->first_name ?? '' . ' ' . optional($value->customer)->last_name ?? '',
                    optional($value->customer)->mobile ?? '',
                    optional($value->customer)->email ?? '',
                    optional($value->customer)->state ?? '',
                    optional($value->order)->invoice_no ?? '',
                    optional($value->customer)->customer_type ?? '',
                    optional($value->customer)->company_name ?? '',
                    optional($value->customer)->gst_number ?? '',
                    $value->amount ?? '',
                    $value->order->gst_amount ?? '',
                    $value->payment_mode ?? '',
                    $value->merchantTxnd ?? '',
                    $value->UTR ?? '',
                    date('d-m-Y',strtotime($value->created_at))
                ];
                fputcsv($errorCsvFile, $row);
            }
            fclose($errorCsvFile);
            return response()->download($errorCsvFileName)->deleteFileAfterSend(true);
                        
    }

    public function wishlistExpert(Request $request){
        return view('admin.export.wishlistexport');
    }

    public function wishlist_expert(Request $request) {
        $start_date = $request->start_date;
        $end_date = $request->end_date;
        $query = Wishlist::select('wishlists.*')->with(['number','user'])
                            ->join('phonenumbers','phonenumbers.id','wishlists.number_id')
                            ->where('phonenumbers.status','Available')->orderBy('id','DESC');
            if (!empty($start_date)) {
                if (!empty($end_date)) {
                    $query->whereDate('wishlists.created_at', '>=', date('Y-m-d',strtotime($start_date)));
                } else {
                    $query->whereDate('wishlists.created_at', '=',  date('Y-m-d',strtotime($start_date)));
                }
            }
            if (!empty($end_date)) {
                $query->whereDate('wishlists.created_at', '<=',  date('Y-m-d',strtotime($end_date)));
            }
            $records = $query->get();

            $errorCsvFileName = 'Wishlistsexport.csv';
            $errorCsvFile = fopen($errorCsvFileName, 'w');
            fputcsv($errorCsvFile, ['SR	','Name','Contact Number','Email','Product']);
            foreach ($records as $key => $value) {
                $row = [
                    $key + 1,
                    optional($value->user)->first_name ?? '' . ' ' . optional($value->user)->last_name ?? '',
                    optional($value->user)->mobile ?? '',
                    optional($value->user)->email ?? '',
                    optional($value->number)->actual_number ?? '',
                ];
                fputcsv($errorCsvFile, $row);
            }
            fclose($errorCsvFile);
            return response()->download($errorCsvFileName)->deleteFileAfterSend(true);
                        
    }
}
