<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Crypt;
use App\Models\Vendor;
use App\Models\Customer;
use App\Models\Enquiry;
use App\Models\Order;
use App\Models\Comment;
use App\Models\User;
use Symfony\Component\HttpFoundation\Response;
use Yajra\Datatables\Datatables;
use File;
use Auth;
use DB;
 
class EnquiriesController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }
    private $data = array(
        'route' => 'admin.enquiries.',
        'title' => 'Enquiries',
        'menu' => 'Enquiries',
        'submenu' => '',
    );


    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $latestEnquiryIds = Enquiry::selectRaw('MAX(id) as id')
                            ->groupBy('user_id');
        if ($request->ajax()) {
            $query = Enquiry::with(['employee'])
                                 ->whereIn('id', $latestEnquiryIds)
                                ->when($request->type && $request->type != 'All', function ($query) use ($request) {
                                    return $query->where('enquirys.status', $request->type);
                                }) 
                                ->when($request->thismonth && $request->thismonth == 'thismonth', function ($query) use ($request) {
                                    return $query->whereYear('created_at', '=', date('Y'))->whereMonth('created_at', '=', date('m'));
                                })  
                                ->when($request->startDate, function ($query) use ($request) {
                                    $startDate = date('Y-m-d 00:00:00', strtotime($request->startDate));
                                    if ($request->endDate) {
                                        $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                                        return $query->whereBetween('enquirys.created_at', [$startDate, $endDate]);
                                    }
                                    return $query->where('enquirys.created_at', '>=', $startDate);
                                })
                                ->when($request->endDate && !$request->startDate, function ($query) use ($request) {
                                    $endDate = date('Y-m-d 23:59:59', strtotime($request->endDate));
                                    return $query->where('enquirys.created_at', '<=', $endDate);
                                });
            $records = $query->orderBy('enquirys.id', 'DESC');
             $sr = 1;   
            return Datatables::of($records)
                ->addIndexColumn()
                ->addColumn('sr_no', function ($record) use (&$sr) {
                    return $sr++;
                })
              
                ->editColumn('created_at',function($record){
                    return date('d-m-Y h:i a',strtotime($record->created_at));
                })
                ->editColumn('assign_to',function($record){
                    return $record->employee->name??'-';
                })
                ->addColumn('action', function ($record) {
                    return '<a href="'.url('admin/enquiries/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>';
                })
                ->rawColumns(['action','sr_no'])
                ->make(true);
        }
       
       
        return view('admin.enquiries.index',$this->data);
    
    }
 
    public function edit($id)
    {
		$enquiry = Enquiry::find($id);

        $customer = Customer::find($enquiry->user_id);

        $enquiries = Enquiry::where('user_id',$enquiry->user_id)->orwhere('mobile',$customer->mobile)->get();
        $enquirie_id = Enquiry::where('user_id',$enquiry->user_id)->pluck('id');
        $order = Order::where('mobile_no',$enquiry->mobile)->get();
		
      
        return view('admin.enquiries.edit',['enquiry'=>$enquiry,'enquiries'=>$enquiries,'order'=>$order,'enquirie_id'=>$enquirie_id]);
    }
   
    public function destroy(Request $request)
    {
        $admin = Payment::find($request->id);
         
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 

        Payment::where('id', '=', $admin->id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }
    public function addcomment(Request $request)
    {

        $input['employee_id'] = $request->employee_id;
        $input['status'] = $request->status;
        $input['enquiry_id'] = $request->enquiry_id;
        $input['enquiry_comment'] = $request->enquiry_comment;
        $comment = new Comment($input);
        $comment->save();
        Enquiry::where('user_id', $request->user_id)
                ->update([
                    'assign_to' => $request->employee_id,
                    'status' => $request->status,
                ]);
        // $enquiry = Enquiry::find($request->enquiry_id);
        // $enquiry->assign_to = $request->employee_id;
        // $enquiry->status = $request->status;
        // $enquiry->update();
        return redirect()->back()->withSuccess('Update successfully');
       

    }
}
