<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Crypt;
use App\Models\Commission;
use File;
use Auth;
use DB;
use Symfony\Component\HttpFoundation\Response;
use Yajra\Datatables\Datatables;
class CommissionController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }
    private $data = array(
        'route' => 'admin.commission.',
        'title' => 'Commission',
        'menu' => 'Commission',
        'submenu' => '',
    );

    public function index(Request $request)
    {
            if ($request->ajax()) {
                $records = Commission::select('commissiones.*')->orderBy('id','DESC');
                 $sr = 1;
                return Datatables::of($records)
                    ->addIndexColumn()
                    ->editColumn('created_at', function ($record) {
                        return $record->created_at->format('d-m-Y H:m:s');
                    })
                    ->addColumn('action', function ($record) {
                        return '<a href="'.url('admin/commission/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                              '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                    })
                    ->rawColumns(['action'])
                    ->make(true);
            }
            return view('admin.commission.index',$this->data);
        
    }

   
    public function create()
    {
        $commission = [];
        return view('admin.commission.create',$commission);
    }

   
    public function store(Request $request)
    {
		
        $sValidationRules = [
            'from_amount' => 'required',
			'to_amount' => 'required',
            'commission' => 'required',
            'commission_flat' => 'required',
        ];
		
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) 
        {
            return redirect('admin/phone/create')->withErrors($validator)->withInput();
        }  
		
        $input = $request->all();
       	$admin = New Commission($input);
        $admin->save();
		
        return redirect('admin/commission')->withSuccess('Added successfully');
    }

    public function show($id)
    {
		$number = Commission::find($id);
        return view('admin.commission.show')->with(['number'=>$number]);
    }

 
    public function edit($id)
    {
        
		$commission = Commission::find($id);
        return view('admin.commission.create',['commission'=>$commission]);
    }

 
    public function update(Request $request,$id)
    {
		$input = $request->all();
		$vendor = Commission::find($id);
       
		 if ($request->ajax()) {
			 
            if(!empty($request->currentStatus))
            {
                if($request->currentStatus == 'Active')
                {
                    $vendor->status = 'Deactive';
                }	
                else{
                    $vendor->status = 'Active';
                }		  
            }
		  $vendor->save();
          $response['success'] = true;
          $response['message'] = 'Update successfully';
          return response()->json($response);
		
			 
		 }
         $sValidationRules = [
            'from_amount' => 'required',
			'to_amount' => 'required',
            'commission' => 'required',
            'commission_flat' => 'required',
        ];
		
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect('admin/commission/create')->withErrors($validator)->withInput();
        }  
       
        $vendor->update($input);
        return redirect('admin/commission')->withSuccess('Update successfully');
    }

  
    public function destroy($id)
    {
        $admin = Commission::find($id);
        Commission::where('id', '=', $id)->delete();
        $response['success'] = true;
        $response['message'] = 'Deleted successfully';
        return response()->json($response);
    }
   
}
