<?php

namespace App\Http\Controllers\AdminAuth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\Category;
use File;
use Auth;
use DB;
use Yajra\Datatables\Datatables;
use App\Models\CategoryImage;
use App\Models\Phonenumber;
class CategoryController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
      
    }

    /**
     * show dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    private $data = array(
        'route' => 'admin.category.',
        'title' => 'Category',
        'menu' => 'Category',
        'submenu' => '',
    );
    public function index(Request $request)
    {
       
        if ($request->ajax()) {
               
            $records = Category::select('categories.*');
             $sr = 1;
            return Datatables::of($records)
                ->addIndexColumn()
                
            
                ->editColumn('status', function ($record) {
                    return '<div class="form-check form-switch">
                            <input class="form-check-input status-toggle" id="statusToggle" type="checkbox" data-id="' . $record->id . '" data-status="' . $record->status . '" ' . ($record->status == "Active" ? "checked" : "") . '></div>';
                })
                ->editColumn('image', function($record){
                    return '<img src="' . $record->image_url . '" style=" height:120px;">';
                })
                ->addColumn('action', function ($record) {
                    return '<a href="'.url('admin/category/'.$record->id.'/edit').'" class="btn btn-sm btn-info btn-b" data-bs-toggle="tooltip" title="" data-bs-original-title="edit"><i class="fe fe-edit"></i></a>'.
                          '&nbsp;<button  class="btn btn-sm btn-danger data-delete" data-id="'.$record->id.'"  data-bs-toggle="tooltip" title="" data-bs-original-title="delete"><i class="fe fe-trash-2"></i></button>';
                })
                ->rawColumns(['status','action','image'])
                ->make(true);
        }
            return view('admin.category.index',$this->data);
        
    }
    public function create()
    {
		$category = [];
        return view('admin.category.create')->with(['category'=>$category]);
    }

   
    public function store(Request $request)
    {
        $sValidationRules = [
            'name' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,webp',
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails()) // on validator found any error 
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }        
        $admin = New Category;
        $admin->name = $request->name;
       
		
		$str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$admin->slug = rtrim($str, '-');
       
       
          if($request->hasFile('image')){
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/category'), $image);
            $admin->image = 'uploads/category/'.$image;
        } 
        if($request->hasFile('multi_cat_image')){

            foreach($request->multi_cat_image as $image){

                $image_name = rand().time().'.'.$image->extension();
                $image->move(public_path('uploads/category'), $image_name);

                $admin->categoryImages()->create([
                    'image' => 'uploads/category/'.$image_name
                ]);

            }
        }
      
        $admin->save();
        return redirect('admin/category')->withSuccess('Added successfully');
    }

    public function show($id)
    {
		$category = Category::find($id);
        return view('admin.category.show')->with(['category'=>$category]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
		$category = Category::with('categoryImages')->find($id);
		
        return view('admin.category.create',['category'=>$category]);
    }

 
    public function update(Request $request,Category $category)
    {
	
		 if ($request->ajax()) {
			 
			 if(!empty($request->currentStatus))
		{
	      if($request->currentStatus == 'Active')
          {
			  $category->status = 'Deactive';
		  }	
          else{
			  $category->status = 'Active';
		  }		  
		}
		  $category->save();
		  $response['success'] = true;
        $response['message'] = 'Update successfully';
        return response()->json($response);
		
			 
		 }
        $sValidationRules = [
             'name' => 'required',
             'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp',
       
        ];
        $validator = Validator::make($request->all(), $sValidationRules);
        if ($validator->fails())  
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }
		
		
        
		
        $category->name = $request->name;
     
        $str = strtolower(trim($request->name));
		$str = preg_replace('/[^a-z0-9-]/', '-', $str);
		$str = preg_replace('/-+/', "-", $str);
		$category->slug = rtrim($str, '-');
      
        
       
      if($request->hasFile('image')){
            if(file_exists(asset($category->image))){
                unlink(asset($category->image));
            }
            $image = rand().time().'.'.$request->image->extension();
            $request->image->move(public_path('uploads/category'), $image);
            $category->image = 'uploads/category/'.$image;
        } 
        if($request->hasFile('multi_cat_image')){
            foreach($request->multi_cat_image as $image){
                $image_name = rand().time().'.'.$image->extension();
                $image->move(public_path('uploads/category'), $image_name);
                $category->categoryImages()->create([
                    'image' => 'uploads/category/'.$image_name
                ]);
            }
        }
        $category->save();
        return redirect('admin/category')->withSuccess('Update successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $admin = Category::find($request->id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        Category::where('id', '=', $request->id)->delete();
        $response['success'] = true;
        $response['message'] = 'Update successfully';
        return response()->json($response);
    }
	
	 public function categorydelete($id)
    {
        $admin = Category::find($id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        Category::where('id', '=', $id)->delete();
        $response['success'] = true;
        $response['message'] = 'Update successfully';
        return response()->json($response);
    }
    
    public function categoryImageDelete(Request $request)
    {
        $admin = CategoryImage::find($request->id);
        if (File::exists(public_path($admin['image']))) {
            File::delete(public_path($admin['image']));
        } 
        CategoryImage::where('id', '=', $request->id)->delete();
        $response['success'] = true;
        $response['message'] = 'Delete successfully';
        return response()->json($response);
    }
}
